/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.client.util;

import net.minecraft.util.math.Vec3d;

public class BirdOrientation {
    public float yawDeg;
    public float pitchDeg;
    public float rollDeg;
    private float lastYaw;
    private float lastPitch;
    private float lastRoll;

    private static double clamp(double v, double lo, double hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    public void updateFromVelocity(Vec3d vel, float maxYawStepDeg, float maxPitchStepDeg, float maxRollStepDeg) {
        if (vel.func_189985_c() < 1.0E-4) {
            this.yawDeg = this.lastYaw;
            this.pitchDeg = this.lastPitch;
            this.rollDeg = this.lastRoll;
            return;
        }
        Vec3d v = vel.func_72432_b();
        float targetYaw = (float)Math.toDegrees(Math.atan2(v.field_72450_a, v.field_72449_c));
        double horiz = Math.sqrt(v.field_72450_a * v.field_72450_a + v.field_72449_c * v.field_72449_c);
        float targetPitch = (float)(-Math.toDegrees(Math.atan2(v.field_72448_b, horiz)));
        this.yawDeg = BirdOrientation.approachAngle(this.lastYaw, targetYaw, maxYawStepDeg);
        this.pitchDeg = BirdOrientation.approach(this.lastPitch, targetPitch, maxPitchStepDeg);
        this.rollDeg = BirdOrientation.approach(this.lastRoll, this.rollDeg, maxRollStepDeg);
        this.lastYaw = this.yawDeg;
        this.lastPitch = this.pitchDeg;
        this.lastRoll = this.rollDeg;
    }

    private static float approachAngle(float current, float target, float maxStep) {
        float delta = BirdOrientation.wrapDegrees(target - current);
        if (Math.abs(delta) <= maxStep) {
            return target;
        }
        return current + Math.signum(delta) * maxStep;
    }

    private static float approach(float current, float target, float maxStep) {
        float delta = target - current;
        if (Math.abs(delta) <= maxStep) {
            return target;
        }
        return current + Math.signum(delta) * maxStep;
    }

    private static float wrapDegrees(float deg) {
        if ((deg %= 360.0f) >= 180.0f) {
            deg -= 360.0f;
        }
        if (deg < -180.0f) {
            deg += 360.0f;
        }
        return deg;
    }

    public void setTargetRoll(float targetRollDeg, float maxStepDeg) {
        this.lastRoll = this.rollDeg = BirdOrientation.approach(this.lastRoll, targetRollDeg, maxStepDeg);
    }
}

