/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.client.util;

import java.util.Random;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Flock {
    public final long flockId;
    private final Random rng;
    private Vec3d groupForward = new Vec3d(0.0, 0.0, 1.0);
    private int ticksToChange = 120;

    public Flock(long flockId, Vec3d initialForward) {
        this.flockId = flockId;
        this.rng = new Random(flockId);
        this.groupForward = new Vec3d(initialForward.field_72450_a, 0.0, initialForward.field_72449_c).func_72432_b();
        if (this.groupForward.func_189985_c() < 1.0E-6) {
            this.groupForward = new Vec3d(0.0, 0.0, 1.0);
        }
        this.ticksToChange = 80 + this.rng.nextInt(180);
    }

    public void tick(World world) {
        if (--this.ticksToChange <= 0) {
            this.nudgeHeading();
            this.ticksToChange = 80 + this.rng.nextInt(220);
        }
    }

    private void nudgeHeading() {
        double ang = (this.rng.nextDouble() - 0.5) * Math.toRadians(35.0);
        double x = this.groupForward.field_72450_a;
        double z = this.groupForward.field_72449_c;
        double cos = Math.cos(ang);
        double sin = Math.sin(ang);
        double nx = x * cos - z * sin;
        double nz = x * sin + z * cos;
        this.groupForward = new Vec3d(nx, 0.0, nz).func_72432_b();
    }

    public Vec3d getGroupForward() {
        return this.groupForward;
    }
}

