/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.client.util;

import com.jubitus.birds.client.ClientBird;
import com.jubitus.birds.client.config.BirdConfig;
import com.jubitus.birds.client.util.BirdSteering;
import com.jubitus.birds.client.util.Flock;
import com.jubitus.birds.species.BirdSpecies;
import com.jubitus.birds.species.BirdSpeciesRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FlockSpawner {
    public static SpawnResult spawnForCells(World world, EntityPlayer player, long worldSeed, int dim, long window, int cellX, int cellZ, int radiusCells) {
        boolean isDay = world.func_72935_r();
        SpawnResult result = new SpawnResult();
        for (int dx = -radiusCells; dx <= radiusCells; ++dx) {
            for (int dz = -radiusCells; dz <= radiusCells; ++dz) {
                boolean spawnFlock;
                int cx = cellX + dx;
                int cz = cellZ + dz;
                long seed = FlockSpawner.mixSeed(worldSeed, dim, cx, cz, window);
                Random rng = new Random(seed);
                Biome biome = world.func_180494_b(new BlockPos(player.field_70165_t, 0.0, player.field_70161_v));
                BirdSpecies species = BirdSpeciesRegistry.pickForBiome(biome, rng, isDay);
                if (species == null) continue;
                BirdSpecies.BirdSpeciesView view = species.viewForTime(isDay);
                double chance = FlockSpawner.clamp01(view.flockChancePerCell());
                boolean bl = spawnFlock = rng.nextDouble() < chance;
                if (spawnFlock) {
                    FlockSpawner.spawnOneFlock(world, player, rng, seed, result, species, view);
                    continue;
                }
                FlockSpawner.spawnSingles(world, player, rng, seed, result, species, view);
            }
        }
        return result;
    }

    private static long mixSeed(long a, long b, long c, long d, long e) {
        long x = a;
        x ^= b * -7046029254386353131L;
        x ^= c * -4417276706812531889L;
        x ^= d * 1609587929392839161L;
        x ^= e * -2048144789L;
        x ^= x >>> 33;
        x *= -49064778989728563L;
        x ^= x >>> 33;
        x *= -4265267296055464877L;
        x ^= x >>> 33;
        return x;
    }

    private static double clamp01(double v) {
        return Math.max(0.0, Math.min(1.0, v));
    }

    private static void spawnOneFlock(World world, EntityPlayer player, Random rng, long seed, SpawnResult out, BirdSpecies species, BirdSpecies.BirdSpeciesView view) {
        long flockId = FlockSpawner.mixSeed(seed, 999L, 7L, 0L, 0L);
        FlockSpawn base = FlockSpawner.createFlockSpawn(world, player, rng, view);
        Flock flock = new Flock(flockId, base.baseDir);
        out.flocks.put(flockId, flock);
        int size = FlockSpawner.chooseFlockSize(world, rng, species);
        for (int i = 0; i < size; ++i) {
            long birdId = FlockSpawner.mixSeed(seed, i, 2L, 0L, 0L);
            double spread = size <= 10 ? 3.0 + rng.nextDouble() * 8.0 : 6.0 + rng.nextDouble() * 18.0;
            double a = rng.nextDouble() * Math.PI * 2.0;
            double ox = Math.cos(a) * spread;
            double oz = Math.sin(a) * spread;
            double oy = (rng.nextDouble() - 0.5) * 3.0;
            Vec3d pos = base.centerPos.func_72441_c(ox, oy, oz);
            Vec3d jitter = new Vec3d((rng.nextDouble() - 0.5) * 0.15, 0.0, (rng.nextDouble() - 0.5) * 0.15);
            Vec3d dir = base.baseDir.func_178787_e(jitter).func_72432_b();
            double speed = base.baseSpeed * (0.9 + rng.nextDouble() * 0.2);
            ClientBird b = new ClientBird(world, species, birdId, pos, dir, speed);
            b.flockId = flockId;
            out.birds.add(b);
        }
    }

    private static void spawnSingles(World world, EntityPlayer player, Random rng, long seed, SpawnResult out, BirdSpecies species, BirdSpecies.BirdSpeciesView view) {
        int max = Math.max(0, view.birdsPerCellMax());
        int count = rng.nextInt(max + 1);
        for (int i = 0; i < count; ++i) {
            long birdId = FlockSpawner.mixSeed(seed, i, 1L, 0L, 0L);
            ClientBird b = FlockSpawner.spawnBird(world, player, rng, birdId, 0L, null, species, view);
            out.birds.add(b);
        }
    }

    private static FlockSpawn createFlockSpawn(World world, EntityPlayer player, Random rng, BirdSpecies.BirdSpeciesView view) {
        FlockSpawn s = new FlockSpawn();
        int viewChunks = Minecraft.func_71410_x().field_71474_y.field_151451_c;
        double viewBorder = (double)viewChunks * 16.0;
        double spawnDist = viewBorder + BirdConfig.spawnBorderBuffer + rng.nextDouble() * 64.0;
        double angle = rng.nextDouble() * Math.PI * 2.0;
        double sx = player.field_70165_t + Math.cos(angle) * spawnDist;
        double sz = player.field_70161_v + Math.sin(angle) * spawnDist;
        double ground = world.func_175645_m(new BlockPos(sx, 0.0, sz)).func_177956_o();
        double above = BirdSteering.lerp(view.minAltitudeAboveGround(), view.maxAltitudeAboveGround(), rng.nextDouble());
        double sy = ground + above;
        s.centerPos = new Vec3d(sx, sy, sz);
        Vec3d outward = new Vec3d(sx - player.field_70165_t, 0.0, sz - player.field_70161_v);
        if (outward.func_189985_c() < 1.0E-6) {
            outward = new Vec3d(0.0, 0.0, 1.0);
        }
        outward = outward.func_72432_b();
        Vec3d inward = outward.func_186678_a(-1.0);
        Vec3d side = new Vec3d(-outward.field_72449_c, 0.0, outward.field_72450_a);
        double sideAmt = (rng.nextDouble() - 0.5) * 1.2;
        s.baseDir = inward.func_178787_e(side.func_186678_a(sideAmt)).func_72432_b();
        s.baseSpeed = BirdSteering.lerp(view.minSpeed(), view.maxSpeed(), rng.nextDouble());
        return s;
    }

    private static int chooseFlockSize(World world, Random rng, BirdSpecies species) {
        double bigChance;
        boolean day = world.func_72935_r();
        double d = bigChance = day ? species.bigFlockChanceDay : species.bigFlockChanceNight;
        if (rng.nextDouble() < bigChance) {
            int min = Math.min(species.bigFlockMin, species.bigFlockMax);
            int max = Math.max(species.bigFlockMin, species.bigFlockMax);
            return min + rng.nextInt(max - min + 1);
        }
        int min = Math.min(species.flockMin, species.flockMax);
        int max = Math.max(species.flockMin, species.flockMax);
        return min + rng.nextInt(max - min + 1);
    }

    private static ClientBird spawnBird(World world, EntityPlayer player, Random rng, long birdId, long flockId, Flock flock, BirdSpecies species, BirdSpecies.BirdSpeciesView view) {
        Vec3d dir;
        int viewChunks = Minecraft.func_71410_x().field_71474_y.field_151451_c;
        double viewBorder = (double)viewChunks * 16.0;
        double spawnDist = viewBorder + BirdConfig.spawnBorderBuffer + rng.nextDouble() * 64.0;
        double angle = rng.nextDouble() * Math.PI * 2.0;
        double sx = player.field_70165_t + Math.cos(angle) * spawnDist;
        double sz = player.field_70161_v + Math.sin(angle) * spawnDist;
        if (flockId != 0L) {
            double spread = 14.0 + rng.nextDouble() * 22.0;
            double a2 = rng.nextDouble() * Math.PI * 2.0;
            sx += Math.cos(a2) * spread;
            sz += Math.sin(a2) * spread;
        }
        BlockPos bp = new BlockPos(sx, 0.0, sz);
        double ground = world.func_175645_m(bp).func_177956_o();
        double above = BirdSteering.lerp(view.minAltitudeAboveGround(), view.maxAltitudeAboveGround(), rng.nextDouble());
        double sy = ground + above;
        Vec3d pos = new Vec3d(sx, sy, sz);
        if (flock != null) {
            Vec3d gf = flock.getGroupForward();
            Vec3d jitter = new Vec3d((rng.nextDouble() - 0.5) * 0.25, 0.0, (rng.nextDouble() - 0.5) * 0.25);
            dir = gf.func_178787_e(jitter).func_72432_b();
        } else {
            Vec3d outward = new Vec3d(sx - player.field_70165_t, 0.0, sz - player.field_70161_v);
            if (outward.func_189985_c() < 1.0E-6) {
                outward = new Vec3d(0.0, 0.0, 1.0);
            }
            outward = outward.func_72432_b();
            Vec3d inward = outward.func_186678_a(-1.0);
            Vec3d side = new Vec3d(-outward.field_72449_c, 0.0, outward.field_72450_a);
            double sideAmt = (rng.nextDouble() - 0.5) * 1.2;
            dir = inward.func_178787_e(side.func_186678_a(sideAmt)).func_72432_b();
        }
        double speed = BirdSteering.lerp(view.minSpeed(), view.maxSpeed(), rng.nextDouble());
        ClientBird b = new ClientBird(world, species, birdId, pos, dir, speed);
        b.flockId = flockId;
        return b;
    }

    private static class FlockSpawn {
        Vec3d centerPos;
        Vec3d baseDir;
        double baseSpeed;

        private FlockSpawn() {
        }
    }

    public static class SpawnResult {
        public final List<ClientBird> birds = new ArrayList<ClientBird>();
        public final Map<Long, Flock> flocks = new HashMap<Long, Flock>();
    }
}

