/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.client.util;

import com.jubitus.birds.client.ClientBird;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.Vec3d;

public class SpatialHash {
    private final int cellSize;
    private final Map<Long, List<ClientBird>> buckets = new HashMap<Long, List<ClientBird>>();

    public SpatialHash(int cellSize) {
        this.cellSize = Math.max(8, cellSize);
    }

    public void clear() {
        this.buckets.clear();
    }

    public void insert(ClientBird b) {
        long key = this.key(b.pos);
        this.buckets.computeIfAbsent(key, k -> new ArrayList()).add(b);
    }

    private long key(Vec3d p) {
        int cx = SpatialHash.floorDiv((int)Math.floor(p.field_72450_a), this.cellSize);
        int cz = SpatialHash.floorDiv((int)Math.floor(p.field_72449_c), this.cellSize);
        return SpatialHash.pack(cx, cz);
    }

    private static int floorDiv(int a, int b) {
        int r = a / b;
        if ((a ^ b) < 0 && r * b != a) {
            --r;
        }
        return r;
    }

    private static long pack(int x, int z) {
        return (long)x << 32 ^ (long)z & 0xFFFFFFFFL;
    }

    public List<ClientBird> queryNearby(Vec3d pos) {
        int cx = SpatialHash.floorDiv((int)Math.floor(pos.field_72450_a), this.cellSize);
        int cz = SpatialHash.floorDiv((int)Math.floor(pos.field_72449_c), this.cellSize);
        ArrayList<ClientBird> out = new ArrayList<ClientBird>();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                long k = SpatialHash.pack(cx + dx, cz + dz);
                List<ClientBird> list = this.buckets.get(k);
                if (list == null) continue;
                out.addAll(list);
            }
        }
        return out;
    }
}

