/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.render;

import com.jubitus.birds.client.ClientBird;
import com.jubitus.birds.render.BirdTexture;
import java.util.Collection;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class RenderBird {
    public static void renderAll(Collection<ClientBird> birds, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        Vec3d camPos = new Vec3d(mc.func_175598_ae().field_78730_l, mc.func_175598_ae().field_78731_m, mc.func_175598_ae().field_78728_n);
        boolean fogWasEnabled = GL11.glIsEnabled((int)2912);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        mc.field_71460_t.func_180436_i();
        GlStateManager.func_179127_m();
        for (ClientBird b : birds) {
            RenderBird.renderOne(b, camPos, partialTicks);
        }
        if (!fogWasEnabled) {
            GlStateManager.func_179106_n();
        }
        mc.field_71460_t.func_175072_h();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private static void renderOne(ClientBird b, Vec3d camPos, float partialTicks) {
        double halfL;
        Minecraft mc = Minecraft.func_71410_x();
        Vec3d p0 = b.prevPos != null ? b.prevPos : b.pos;
        Vec3d p1 = b.pos;
        double ix = p0.field_72450_a + (p1.field_72450_a - p0.field_72450_a) * (double)partialTicks;
        double iy = p0.field_72448_b + (p1.field_72448_b - p0.field_72448_b) * (double)partialTicks;
        double iz = p0.field_72449_c + (p1.field_72449_c - p0.field_72449_c) * (double)partialTicks;
        double x = ix - camPos.field_72450_a;
        double y = iy - camPos.field_72448_b;
        double z = iz - camPos.field_72449_c;
        ResourceLocation tex = BirdTexture.get(b);
        if (tex == null) {
            return;
        }
        mc.func_110434_K().func_110577_a(tex);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        double scale = b.species != null ? b.species.scale : 0.45;
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        double cx = camPos.field_72450_a - ix;
        double cy = camPos.field_72448_b - iy;
        double cz = camPos.field_72449_c - iz;
        double dist = Math.sqrt(cx * cx + cy * cy + cz * cz);
        double invLen = dist > 1.0E-6 ? 1.0 / dist : 0.0;
        double dxN = cx * invLen;
        double dyN = cy * invLen;
        double dzN = cz * invLen;
        float distFactor = (float)RenderBird.clamp01((dist - 12.0) / 64.0);
        float horizonFactor = 1.0f - (float)Math.min(1.0, Math.abs(dyN));
        float tiltStrength = distFactor * horizonFactor;
        float maxTiltDeg = 25.0f;
        float tiltX = (float)(dzN * (double)maxTiltDeg * (double)tiltStrength);
        float tiltZ = (float)(-dxN * (double)maxTiltDeg * (double)tiltStrength);
        GlStateManager.func_179114_b((float)tiltZ, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)tiltX, (float)1.0f, (float)0.0f, (float)0.0f);
        int bx = (int)Math.floor(ix);
        int by = (int)Math.floor(iy);
        int bz = (int)Math.floor(iz);
        int packedLight = mc.field_71441_e.func_175626_b(new BlockPos(bx, by, bz), 0);
        int u = packedLight & 0xFFFF;
        int v = packedLight >> 16 & 0xFFFF;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)u, (float)v);
        float yaw = RenderBird.lerpAngle(b.prevYaw, b.orientation.yawDeg, partialTicks);
        float pitch = RenderBird.lerpAngle(b.prevPitch, b.orientation.pitchDeg, partialTicks);
        float roll = RenderBird.lerpAngle(b.prevRoll, b.orientation.rollDeg, partialTicks);
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)roll, (float)0.0f, (float)0.0f, (float)1.0f);
        double t = (float)mc.field_71441_e.func_82737_E() + partialTicks;
        double amp = b.species != null ? b.species.flapAmplitude : 0.08;
        double spd = b.species != null ? b.species.flapSpeed : 0.35;
        double flap = amp * Math.sin((t + (double)(b.hashCode() & 0xFF)) * spd);
        double halfW = 1.2 + flap;
        double zHead = halfL = 0.7;
        double zTail = -halfL;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        float a = RenderBird.fogFadeAlpha(mc, camPos, ix, iy, iz);
        if (a <= 0.01f) {
            GlStateManager.func_179121_F();
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(-halfW, 0.0, zHead).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(halfW, 0.0, zHead).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(halfW, 0.0, zTail).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(-halfW, 0.0, zTail).func_187315_a(0.0, 1.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private static double clamp01(double v) {
        if (v < 0.0) {
            return 0.0;
        }
        if (v > 1.0) {
            return 1.0;
        }
        return v;
    }

    private static float lerpAngle(float a, float b, float t) {
        float delta = RenderBird.wrapDegrees(b - a);
        return a + delta * t;
    }

    private static float fogFadeAlpha(Minecraft mc, Vec3d camPos, double wx, double wy, double wz) {
        double fogStart;
        double dx = wx - camPos.field_72450_a;
        double dy = wy - camPos.field_72448_b;
        double dz = wz - camPos.field_72449_c;
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double fogEnd = (double)mc.field_71474_y.field_151451_c * 16.0;
        boolean underwater = mc.field_71439_g != null && mc.field_71439_g.func_70055_a(Material.field_151586_h);
        fogEnd = underwater ? fogEnd * 0.35 : fogEnd;
        double a = (fogEnd - dist) / (fogEnd - (fogStart = underwater ? fogEnd * 0.1 : fogEnd * 0.65));
        if (a < 0.0) {
            a = 0.0;
        }
        if (a > 1.0) {
            a = 1.0;
        }
        if (underwater) {
            a *= 0.7;
        }
        return (float)a;
    }

    private static float wrapDegrees(float deg) {
        if ((deg %= 360.0f) >= 180.0f) {
            deg -= 360.0f;
        }
        if (deg < -180.0f) {
            deg += 360.0f;
        }
        return deg;
    }
}

