/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.species;

import com.jubitus.birds.JubitusBirds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BiomeNameResolver {
    public static ResolvedBiomeLists resolveLists(List<String> whitelist, List<String> blacklist, String speciesName) {
        HashMap<String, Biome> byRegistry = new HashMap<String, Biome>();
        HashMap<String, List<Biome>> byNameNorm = new HashMap<String, List<Biome>>();
        for (Biome b : ForgeRegistries.BIOMES.getValuesCollection()) {
            if (b == null) continue;
            ResourceLocation rl = b.getRegistryName();
            if (rl != null) {
                byRegistry.put(rl.toString().toLowerCase(Locale.ROOT), b);
            }
            String n = b.func_185359_l();
            String norm = BiomeNameResolver.normalize(n);
            byNameNorm.computeIfAbsent(norm, k -> new ArrayList()).add(b);
            if (rl == null) continue;
            String normPath = BiomeNameResolver.normalize(rl.func_110623_a());
            byNameNorm.computeIfAbsent(normPath, k -> new ArrayList()).add(b);
        }
        Set<String> wlIds = BiomeNameResolver.resolveToRegistryIds(whitelist, byRegistry, byNameNorm, speciesName, "whitelist");
        Set<String> blIds = BiomeNameResolver.resolveToRegistryIds(blacklist, byRegistry, byNameNorm, speciesName, "blacklist");
        return new ResolvedBiomeLists(wlIds, blIds);
    }

    public static String normalize(String s) {
        if (s == null) {
            return "";
        }
        String x = s.toLowerCase(Locale.ROOT);
        x = x.replace('+', ' ');
        x = x.replaceAll("[^a-z0-9\\s]", " ");
        x = x.replaceAll("\\s+", " ").trim();
        return x;
    }

    private static Set<String> resolveToRegistryIds(List<String> raw, Map<String, Biome> byRegistry, Map<String, List<Biome>> byNameNorm, String speciesName, String whichList) {
        HashSet<String> out = new HashSet<String>();
        if (raw == null) {
            return out;
        }
        for (String entry : raw) {
            String s;
            if (entry == null || (s = entry.trim()).isEmpty()) continue;
            String lower = s.toLowerCase(Locale.ROOT);
            if (lower.contains(":")) {
                Biome b = byRegistry.get(lower);
                if (b != null && b.getRegistryName() != null) {
                    out.add(b.getRegistryName().toString());
                    continue;
                }
                JubitusBirds.LOGGER.warn("[JubitusBirds] Species '{}' {} entry '{}' did not match any biome registry id.", (Object)speciesName, (Object)whichList, (Object)s);
                continue;
            }
            String norm = BiomeNameResolver.normalize(s);
            List<Biome> matches = byNameNorm.get(norm);
            if (matches == null || matches.isEmpty()) {
                JubitusBirds.LOGGER.warn("[JubitusBirds] Species '{}' {} entry '{}' did not match any biome name.", (Object)speciesName, (Object)whichList, (Object)s);
                continue;
            }
            if (matches.size() > 1) {
                StringBuilder sb = new StringBuilder();
                for (Biome b : matches) {
                    if (b.getRegistryName() == null) continue;
                    sb.append(b.getRegistryName()).append(" (").append(b.func_185359_l()).append("), ");
                }
                JubitusBirds.LOGGER.warn("[JubitusBirds] Species '{}' {} entry '{}' matched multiple biomes: {}", (Object)speciesName, (Object)whichList, (Object)s, (Object)sb.toString());
            }
            for (Biome b : matches) {
                if (b.getRegistryName() == null) continue;
                out.add(b.getRegistryName().toString());
            }
        }
        return out;
    }

    public static class ResolvedBiomeLists {
        public final Set<String> whitelistRegistryIds;
        public final Set<String> blacklistRegistryIds;

        public ResolvedBiomeLists(Set<String> wl, Set<String> bl) {
            this.whitelistRegistryIds = wl != null ? wl : new HashSet();
            this.blacklistRegistryIds = bl != null ? bl : new HashSet();
        }
    }
}

