/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.species;

import com.jubitus.birds.JubitusBirds;
import com.jubitus.birds.species.BirdSpecies;
import java.util.Locale;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;

public class BiomeRuleResolver {
    public static void resolve(BirdSpecies s) {
        BiomeManager.BiomeType t;
        if (s == null || s.biomeRules == null) {
            return;
        }
        BirdSpecies.BiomeRules r = s.biomeRules;
        r.resolvedTempCats.clear();
        r.resolvedBiomeManagerTypes.clear();
        r.resolvedDictWhitelist.clear();
        r.resolvedDictBlacklist.clear();
        if (r.temperatureCategoryWhitelist != null) {
            for (String x : r.temperatureCategoryWhitelist) {
                Biome.TempCategory cat = BiomeRuleResolver.parseTempCategory(x);
                if (cat != null) {
                    r.resolvedTempCats.add(cat);
                    continue;
                }
                BiomeRuleResolver.warn(s, "temperatureCategoryWhitelist", x);
            }
        }
        if (r.biomeManagerTypeWhitelist != null) {
            for (String x : r.biomeManagerTypeWhitelist) {
                t = BiomeRuleResolver.parseBiomeManagerType(x);
                if (t != null) {
                    r.resolvedBiomeManagerTypes.add(t);
                    continue;
                }
                BiomeRuleResolver.warn(s, "biomeManagerTypeWhitelist", x);
            }
        }
        if (r.biomeDictionaryWhitelist != null) {
            for (String x : r.biomeDictionaryWhitelist) {
                t = BiomeRuleResolver.parseBiomeDictionaryType(x);
                if (t != null) {
                    r.resolvedDictWhitelist.add((BiomeDictionary.Type)t);
                    continue;
                }
                BiomeRuleResolver.warn(s, "biomeDictionaryWhitelist", x);
            }
        }
        if (r.biomeDictionaryBlacklist != null) {
            for (String x : r.biomeDictionaryBlacklist) {
                t = BiomeRuleResolver.parseBiomeDictionaryType(x);
                if (t != null) {
                    r.resolvedDictBlacklist.add((BiomeDictionary.Type)t);
                    continue;
                }
                BiomeRuleResolver.warn(s, "biomeDictionaryBlacklist", x);
            }
        }
    }

    private static Biome.TempCategory parseTempCategory(String s) {
        if (s == null) {
            return null;
        }
        String u = s.trim().toUpperCase(Locale.ROOT);
        try {
            return Biome.TempCategory.valueOf((String)u);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void warn(BirdSpecies s, String field, String value) {
        JubitusBirds.LOGGER.warn("[JubitusBirds] Species '{}' has unknown {} entry '{}'.", (Object)s.name, (Object)field, (Object)value);
    }

    private static BiomeManager.BiomeType parseBiomeManagerType(String s) {
        if (s == null) {
            return null;
        }
        String u = s.trim().toUpperCase(Locale.ROOT);
        try {
            return BiomeManager.BiomeType.valueOf((String)u);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static BiomeDictionary.Type parseBiomeDictionaryType(String s) {
        if (s == null) {
            return null;
        }
        String u = s.trim().toUpperCase(Locale.ROOT);
        try {
            return BiomeDictionary.Type.getType((String)u, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

