/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.species;

import com.jubitus.birds.client.sound.BirdCallType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;

public class BirdSpecies {
    public transient String folderName = "unknown";
    public transient String soundKey = "unknown";
    public SoundSettings soundSingle = null;
    public SoundSettings soundFlock = null;
    public boolean soundsEnabled = true;
    public double soundPitch = 1.0;
    public double soundVolume = 0.8;
    public int soundBaseIntervalTicks = 200;
    public double soundRandomness = 0.35;
    public double soundMaxDistance = 48.0;
    public double soundFadeStart = 12.0;
    public double soundFadePower = 1.0;
    public BiomeRules biomeRules = new BiomeRules();
    public transient Set<String> resolvedWhitelistIds = new HashSet<String>();
    public transient Set<String> resolvedBlacklistIds = new HashSet<String>();
    public boolean canSpawnAtDay = true;
    public boolean canSpawnAtNight = false;
    public String name = "unknown";
    public boolean enabled = true;
    public double spawnWeight = 1.0;
    public int birdsPerCellMax = 8;
    public double flockChancePerCell = 0.45;
    public int flockMin = 3;
    public int flockMax = 10;
    public double bigFlockChanceDay = 0.35;
    public double bigFlockChanceNight = 0.1;
    public int bigFlockMin = 15;
    public int bigFlockMax = 40;
    public List<String> biomeWhitelist = new ArrayList<String>();
    public List<String> biomeBlacklist = new ArrayList<String>();
    public double minSpeed = 0.35;
    public double maxSpeed = 0.6;
    public double maxTurnDegPerTick = 4.0;
    public double noiseStrength = 0.04;
    public double minAltitudeAboveGround = 24.0;
    public double maxAltitudeAboveGround = 96.0;
    public double preferredAboveGround = 48.0;
    public double verticalAdjustStrength = 0.004;
    public int glideMinTicks = 60;
    public int glideMaxTicks = 140;
    public int circleMinTicks = 80;
    public int circleMaxTicks = 220;
    public double circleRadiusMin = 16.0;
    public double circleRadiusMax = 64.0;
    public double patternWeightGlide = 0.55;
    public double patternWeightCircle = 0.45;
    public double scale = 0.45;
    public double flapAmplitude = 0.08;
    public double flapSpeed = 0.35;
    public List<ResourceLocation> textures = new ArrayList<ResourceLocation>();
    public OverrideBlock day = new OverrideBlock();
    public OverrideBlock night = new OverrideBlock();

    public void clampAndFix() {
        if (this.soundPitch <= 0.0) {
            this.soundPitch = 1.0;
        }
        if (this.soundVolume < 0.0) {
            this.soundVolume = 0.0;
        }
        if (this.soundVolume > 4.0) {
            this.soundVolume = 4.0;
        }
        if (this.soundBaseIntervalTicks < 20) {
            this.soundBaseIntervalTicks = 20;
        }
        if (Double.isNaN(this.soundRandomness)) {
            this.soundRandomness = 0.35;
        }
        this.soundRandomness = Math.max(0.0, Math.min(1.0, this.soundRandomness));
        if (Double.isNaN(this.soundMaxDistance) || this.soundMaxDistance < 1.0) {
            this.soundMaxDistance = 48.0;
        }
        if (Double.isNaN(this.soundFadeStart) || this.soundFadeStart < 0.0) {
            this.soundFadeStart = 12.0;
        }
        if (this.soundFadeStart > this.soundMaxDistance) {
            this.soundFadeStart = this.soundMaxDistance * 0.5;
        }
        if (Double.isNaN(this.soundFadePower) || this.soundFadePower <= 0.01) {
            this.soundFadePower = 1.0;
        }
        if (this.soundFadePower > 8.0) {
            this.soundFadePower = 8.0;
        }
        if (this.glideMaxTicks < this.glideMinTicks) {
            this.glideMaxTicks = this.glideMinTicks;
        }
        if (this.circleMaxTicks < this.circleMinTicks) {
            this.circleMaxTicks = this.circleMinTicks;
        }
        if (this.maxSpeed < this.minSpeed) {
            this.maxSpeed = this.minSpeed;
        }
        if (this.maxAltitudeAboveGround < this.minAltitudeAboveGround) {
            this.maxAltitudeAboveGround = this.minAltitudeAboveGround;
        }
        if (this.circleRadiusMax < this.circleRadiusMin) {
            this.circleRadiusMax = this.circleRadiusMin;
        }
        if (Double.isNaN(this.flockChancePerCell)) {
            this.flockChancePerCell = 0.45;
        }
        this.flockChancePerCell = Math.max(0.0, Math.min(1.0, this.flockChancePerCell));
        if (this.birdsPerCellMax < 0) {
            this.birdsPerCellMax = 0;
        }
        if (this.patternWeightGlide <= 0.0 && this.patternWeightCircle <= 0.0) {
            this.patternWeightGlide = 1.0;
            this.patternWeightCircle = 0.0;
        }
        if (this.scale <= 0.0) {
            this.scale = 0.45;
        }
        if (this.flapSpeed <= 0.0) {
            this.flapSpeed = 0.35;
        }
        if (this.flapAmplitude < 0.0) {
            this.flapAmplitude = 0.0;
        }
    }

    public ResourceLocation pickTexture(long birdSeed) {
        if (this.textures.isEmpty()) {
            return null;
        }
        Random r = new Random(birdSeed ^ 0xBEEFL);
        return this.textures.get(r.nextInt(this.textures.size()));
    }

    public BirdSpeciesView viewForTime(boolean isDay) {
        OverrideBlock o = isDay ? this.day : this.night;
        return new BirdSpeciesView(this, o);
    }

    public static class SoundView {
        private final SoundSettings base;
        private final SoundOverride o;

        public SoundView(SoundSettings base, SoundOverride o) {
            this.base = base != null ? base : new SoundSettings();
            this.o = o != null ? o : new SoundOverride();
        }

        public double soundPitch() {
            return this.o.soundPitch != null ? this.o.soundPitch : this.base.soundPitch;
        }

        public double soundVolume() {
            return this.o.soundVolume != null ? this.o.soundVolume : this.base.soundVolume;
        }

        public int soundBaseIntervalTicks() {
            return this.o.soundBaseIntervalTicks != null ? this.o.soundBaseIntervalTicks : this.base.soundBaseIntervalTicks;
        }

        public double soundRandomness() {
            return this.o.soundRandomness != null ? this.o.soundRandomness : this.base.soundRandomness;
        }

        public double soundMaxDistance() {
            return this.o.soundMaxDistance != null ? this.o.soundMaxDistance : this.base.soundMaxDistance;
        }

        public double soundFadeStart() {
            return this.o.soundFadeStart != null ? this.o.soundFadeStart : this.base.soundFadeStart;
        }

        public double soundFadePower() {
            return this.o.soundFadePower != null ? this.o.soundFadePower : this.base.soundFadePower;
        }

        public double soundPitchVariation() {
            return this.o.soundPitchVariation != null ? this.o.soundPitchVariation : this.base.soundPitchVariation;
        }
    }

    public static class SoundOverride {
        public Double soundPitch;
        public Double soundVolume;
        public Integer soundBaseIntervalTicks;
        public Double soundRandomness;
        public Double soundMaxDistance;
        public Double soundFadeStart;
        public Double soundFadePower;
        public Double soundPitchVariation;

        public boolean isEmpty() {
            return this.soundPitch == null && this.soundVolume == null && this.soundBaseIntervalTicks == null && this.soundRandomness == null && this.soundMaxDistance == null && this.soundFadeStart == null && this.soundFadePower == null && this.soundPitchVariation == null;
        }
    }

    public static class SoundSettings {
        public double soundPitch = 1.0;
        public double soundVolume = 1.0;
        public int soundBaseIntervalTicks = 600;
        public double soundRandomness = 0.55;
        public double soundMaxDistance = 128.0;
        public double soundFadeStart = 32.0;
        public double soundFadePower = 1.5;
        public double soundPitchVariation = 0.05;

        public SoundSettings copy() {
            SoundSettings s = new SoundSettings();
            s.soundPitch = this.soundPitch;
            s.soundVolume = this.soundVolume;
            s.soundBaseIntervalTicks = this.soundBaseIntervalTicks;
            s.soundRandomness = this.soundRandomness;
            s.soundMaxDistance = this.soundMaxDistance;
            s.soundFadeStart = this.soundFadeStart;
            s.soundFadePower = this.soundFadePower;
            s.soundPitchVariation = this.soundPitchVariation;
            return s;
        }
    }

    public static class BiomeRules {
        public Double temperatureMin = null;
        public Double temperatureMax = null;
        public List<String> temperatureCategoryWhitelist = new ArrayList<String>();
        public Boolean requiresRain = null;
        public Boolean requiresSnow = null;
        public Boolean requiresOceanic = null;
        public List<String> biomeManagerTypeWhitelist = new ArrayList<String>();
        public List<String> biomeDictionaryWhitelist = new ArrayList<String>();
        public List<String> biomeDictionaryBlacklist = new ArrayList<String>();
        public transient Set<Biome.TempCategory> resolvedTempCats = new HashSet<Biome.TempCategory>();
        public transient Set<BiomeManager.BiomeType> resolvedBiomeManagerTypes = new HashSet<BiomeManager.BiomeType>();
        public transient Set<BiomeDictionary.Type> resolvedDictWhitelist = new HashSet<BiomeDictionary.Type>();
        public transient Set<BiomeDictionary.Type> resolvedDictBlacklist = new HashSet<BiomeDictionary.Type>();
    }

    public static class BirdSpeciesView {
        private final BirdSpecies base;
        private final OverrideBlock o;

        public BirdSpeciesView(BirdSpecies base, OverrideBlock o) {
            this.base = base;
            this.o = o != null ? o : new OverrideBlock();
        }

        public boolean soundsEnabled() {
            return this.o.soundsEnabled != null ? this.o.soundsEnabled : this.base.soundsEnabled;
        }

        public double soundPitch() {
            return this.sound(BirdCallType.SINGLE).soundPitch();
        }

        public SoundView sound(BirdCallType type) {
            if (type == BirdCallType.FLOCK) {
                SoundOverride ov = this.o.soundFlock != null ? this.o.soundFlock : null;
                return new SoundView(this.base.soundFlock, ov);
            }
            SoundOverride ov = this.o.soundSingle != null ? this.o.soundSingle : BirdSpeciesView.legacySingleOverride(this.o);
            return new SoundView(this.base.soundSingle, ov);
        }

        private static SoundOverride legacySingleOverride(OverrideBlock o) {
            if (o == null) {
                return null;
            }
            if (o.soundPitch == null && o.soundVolume == null && o.soundBaseIntervalTicks == null && o.soundRandomness == null && o.soundMaxDistance == null && o.soundFadeStart == null && o.soundFadePower == null) {
                return null;
            }
            SoundOverride so = new SoundOverride();
            so.soundPitch = o.soundPitch;
            so.soundVolume = o.soundVolume;
            so.soundBaseIntervalTicks = o.soundBaseIntervalTicks;
            so.soundRandomness = o.soundRandomness;
            so.soundMaxDistance = o.soundMaxDistance;
            so.soundFadeStart = o.soundFadeStart;
            so.soundFadePower = o.soundFadePower;
            return so;
        }

        public double soundVolume() {
            return this.sound(BirdCallType.SINGLE).soundVolume();
        }

        public int soundBaseIntervalTicks() {
            return this.sound(BirdCallType.SINGLE).soundBaseIntervalTicks();
        }

        public double soundRandomness() {
            return this.sound(BirdCallType.SINGLE).soundRandomness();
        }

        public double soundMaxDistance() {
            return this.sound(BirdCallType.SINGLE).soundMaxDistance();
        }

        public double soundFadeStart() {
            return this.sound(BirdCallType.SINGLE).soundFadeStart();
        }

        public double soundFadePower() {
            return this.sound(BirdCallType.SINGLE).soundFadePower();
        }

        public double soundPitchVariation() {
            return this.sound(BirdCallType.SINGLE).soundPitchVariation();
        }

        public double spawnWeight() {
            return this.o.spawnWeight != null ? this.o.spawnWeight : this.base.spawnWeight;
        }

        public int birdsPerCellMax() {
            return this.o.birdsPerCellMax != null ? this.o.birdsPerCellMax : this.base.birdsPerCellMax;
        }

        public double flockChancePerCell() {
            return this.o.flockChancePerCell != null ? this.o.flockChancePerCell : this.base.flockChancePerCell;
        }

        public int flockMin() {
            return this.o.flockMin != null ? this.o.flockMin : this.base.flockMin;
        }

        public int flockMax() {
            return this.o.flockMax != null ? this.o.flockMax : this.base.flockMax;
        }

        public double minSpeed() {
            return this.o.minSpeed != null ? this.o.minSpeed : this.base.minSpeed;
        }

        public double maxSpeed() {
            return this.o.maxSpeed != null ? this.o.maxSpeed : this.base.maxSpeed;
        }

        public double maxTurnDegPerTick() {
            return this.o.maxTurnDegPerTick != null ? this.o.maxTurnDegPerTick : this.base.maxTurnDegPerTick;
        }

        public double noiseStrength() {
            return this.o.noiseStrength != null ? this.o.noiseStrength : this.base.noiseStrength;
        }

        public double minAltitudeAboveGround() {
            return this.o.minAltitudeAboveGround != null ? this.o.minAltitudeAboveGround : this.base.minAltitudeAboveGround;
        }

        public double maxAltitudeAboveGround() {
            return this.o.maxAltitudeAboveGround != null ? this.o.maxAltitudeAboveGround : this.base.maxAltitudeAboveGround;
        }

        public double preferredAboveGround() {
            return this.o.preferredAboveGround != null ? this.o.preferredAboveGround : this.base.preferredAboveGround;
        }

        public double verticalAdjustStrength() {
            return this.base.verticalAdjustStrength;
        }

        public int glideMinTicks() {
            return this.o.glideMinTicks != null ? this.o.glideMinTicks : this.base.glideMinTicks;
        }

        public int glideMaxTicks() {
            return this.o.glideMaxTicks != null ? this.o.glideMaxTicks : this.base.glideMaxTicks;
        }

        public int circleMinTicks() {
            return this.o.circleMinTicks != null ? this.o.circleMinTicks : this.base.circleMinTicks;
        }

        public int circleMaxTicks() {
            return this.o.circleMaxTicks != null ? this.o.circleMaxTicks : this.base.circleMaxTicks;
        }

        public double circleRadiusMin() {
            return this.o.circleRadiusMin != null ? this.o.circleRadiusMin : this.base.circleRadiusMin;
        }

        public double circleRadiusMax() {
            return this.o.circleRadiusMax != null ? this.o.circleRadiusMax : this.base.circleRadiusMax;
        }

        public double scale() {
            return this.o.scale != null ? this.o.scale : this.base.scale;
        }

        public double flapAmplitude() {
            return this.o.flapAmplitude != null ? this.o.flapAmplitude : this.base.flapAmplitude;
        }

        public double flapSpeed() {
            return this.o.flapSpeed != null ? this.o.flapSpeed : this.base.flapSpeed;
        }

        public BirdSpecies base() {
            return this.base;
        }
    }

    public static class OverrideBlock {
        public SoundOverride soundSingle;
        public SoundOverride soundFlock;
        public Boolean soundsEnabled;
        public Double soundPitch;
        public Double soundVolume;
        public Integer soundBaseIntervalTicks;
        public Double soundRandomness;
        public Double soundMaxDistance;
        public Double soundFadeStart;
        public Double soundFadePower;
        public Double spawnWeight;
        public Integer birdsPerCellMax;
        public Double flockChancePerCell;
        public Integer flockMin;
        public Integer flockMax;
        public Double minSpeed;
        public Double maxSpeed;
        public Double minAltitudeAboveGround;
        public Double maxAltitudeAboveGround;
        public Double preferredAboveGround;
        public Integer glideMinTicks;
        public Integer glideMaxTicks;
        public Integer circleMinTicks;
        public Integer circleMaxTicks;
        public Double circleRadiusMin;
        public Double circleRadiusMax;
        public Double noiseStrength;
        public Double maxTurnDegPerTick;
        public Double scale;
        public Double flapAmplitude;
        public Double flapSpeed;

        public boolean isEmpty() {
            boolean soundSingleEmpty = this.soundSingle == null || this.soundSingle.isEmpty();
            boolean soundFlockEmpty = this.soundFlock == null || this.soundFlock.isEmpty();
            return this.spawnWeight == null && this.birdsPerCellMax == null && this.flockChancePerCell == null && this.flockMin == null && this.flockMax == null && this.minSpeed == null && this.maxSpeed == null && this.minAltitudeAboveGround == null && this.maxAltitudeAboveGround == null && this.preferredAboveGround == null && this.glideMinTicks == null && this.glideMaxTicks == null && this.circleMinTicks == null && this.circleMaxTicks == null && this.circleRadiusMin == null && this.circleRadiusMax == null && this.noiseStrength == null && this.maxTurnDegPerTick == null && this.scale == null && this.flapAmplitude == null && this.soundsEnabled == null && this.soundPitch == null && this.soundVolume == null && this.soundBaseIntervalTicks == null && this.soundRandomness == null && this.soundMaxDistance == null && this.soundFadeStart == null && this.soundFadePower == null && this.flapSpeed == null && soundSingleEmpty && soundFlockEmpty;
        }
    }
}

