/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.species;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.jubitus.birds.JubitusBirds;
import com.jubitus.birds.client.sound.BirdCallType;
import com.jubitus.birds.client.sound.BirdSoundSystem;
import com.jubitus.birds.species.BiomeNameResolver;
import com.jubitus.birds.species.BiomeRuleResolver;
import com.jubitus.birds.species.BirdSpecies;
import com.jubitus.birds.species.BirdSpeciesRegistry;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;

public class BirdSpeciesLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void loadAllSpecies() {
        BirdSpeciesRegistry.clear();
        BirdSoundSystem.clearAllSpeciesSounds();
        Path root = BirdSpeciesLoader.getRootConfigDir();
        if (!Files.exists(root, new LinkOption[0])) {
            JubitusBirds.LOGGER.warn("[JubitusBirds] Species folder does not exist yet: {}", (Object)root.toAbsolutePath());
            return;
        }
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(root);){
            for (Path speciesDir : ds) {
                String soundKey;
                if (!Files.isDirectory(speciesDir, new LinkOption[0])) continue;
                String folderName = speciesDir.getFileName().toString();
                Path props = speciesDir.resolve("properties.json");
                Path texDir = speciesDir.resolve("textures");
                if (!Files.exists(props, new LinkOption[0])) {
                    JubitusBirds.LOGGER.warn("[JubitusBirds] Skipping {} (missing properties.json)", (Object)speciesDir.getFileName());
                    continue;
                }
                if (!Files.isDirectory(texDir, new LinkOption[0])) {
                    JubitusBirds.LOGGER.warn("[JubitusBirds] Skipping {} (missing textures/ folder)", (Object)speciesDir.getFileName());
                    continue;
                }
                BirdSpecies s = BirdSpeciesLoader.readSpeciesJson(folderName, props);
                if (s == null) continue;
                s.folderName = folderName;
                s.soundKey = soundKey = folderName.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9_\\-]", "_");
                int texCount = BirdSpeciesLoader.loadTexturesForSpecies(s, texDir);
                if (texCount <= 0) {
                    JubitusBirds.LOGGER.warn("[JubitusBirds] Skipping {} (no valid PNGs in textures/)", (Object)s.name);
                    continue;
                }
                Path singleDir = speciesDir.resolve("sounds_single");
                Path flockDir = speciesDir.resolve("sounds_flock");
                List<String> singleSounds = BirdSpeciesLoader.loadSoundsForPool(soundKey, "single", singleDir);
                List<String> flockSounds = BirdSpeciesLoader.loadSoundsForPool(soundKey, "flock", flockDir);
                BirdSoundSystem.setSpeciesSounds(soundKey, BirdCallType.SINGLE, singleSounds);
                BirdSoundSystem.setSpeciesSounds(soundKey, BirdCallType.FLOCK, flockSounds);
                s.clampAndFix();
                double singleMax = Math.max(s.viewForTime(true).sound(BirdCallType.SINGLE).soundMaxDistance(), s.viewForTime(false).sound(BirdCallType.SINGLE).soundMaxDistance());
                double flockMax = Math.max(s.viewForTime(true).sound(BirdCallType.FLOCK).soundMaxDistance(), s.viewForTime(false).sound(BirdCallType.FLOCK).soundMaxDistance());
                BirdSoundSystem.setAttenuationDistance(soundKey, BirdCallType.SINGLE, singleMax);
                BirdSoundSystem.setAttenuationDistance(soundKey, BirdCallType.FLOCK, flockMax);
                BiomeNameResolver.ResolvedBiomeLists resolved = BiomeNameResolver.resolveLists(s.biomeWhitelist, s.biomeBlacklist, s.name);
                s.resolvedWhitelistIds = resolved.whitelistRegistryIds;
                s.resolvedBlacklistIds = resolved.blacklistRegistryIds;
                BirdSpeciesRegistry.register(s);
                BiomeRuleResolver.resolve(s);
                JubitusBirds.LOGGER.info("[JubitusBirds] Species '{}' soundKey='{}' singleSounds={} flockSounds={}", (Object)s.name, (Object)s.soundKey, (Object)singleSounds.size(), (Object)flockSounds.size());
                JubitusBirds.LOGGER.info("[JubitusBirds] Loaded default_species '{}' with {} texture(s).", (Object)s.name, (Object)s.textures.size());
            }
        }
        catch (IOException e) {
            JubitusBirds.LOGGER.error("[JubitusBirds] Failed scanning default_species folder.", (Throwable)e);
        }
        if (BirdSpeciesRegistry.all().isEmpty()) {
            JubitusBirds.LOGGER.error("[JubitusBirds] No default_species loaded! Birds will not spawn.");
        }
    }

    public static Path getRootConfigDir() {
        File gameDir = Minecraft.func_71410_x().field_71412_D;
        return gameDir.toPath().resolve("config").resolve("jubitusbirds/default_species");
    }

    private static BirdSpecies readSpeciesJson(String folderName, Path props) {
        try {
            String json = new String(Files.readAllBytes(props), StandardCharsets.UTF_8);
            BirdSpecies s = (BirdSpecies)GSON.fromJson(json, BirdSpecies.class);
            if (s == null) {
                JubitusBirds.LOGGER.warn("[JubitusBirds] Invalid JSON in {} (parsed null).", (Object)props);
                return null;
            }
            if (s.name == null || s.name.trim().isEmpty()) {
                s.name = folderName;
            }
            s.name = s.name.trim();
            return s;
        }
        catch (JsonSyntaxException jse) {
            JubitusBirds.LOGGER.warn("[JubitusBirds] Invalid JSON syntax in {}: {}", (Object)props, (Object)jse.getMessage());
            return null;
        }
        catch (IOException ioe) {
            JubitusBirds.LOGGER.warn("[JubitusBirds] Failed reading {}: {}", (Object)props, (Object)ioe.getMessage());
            return null;
        }
    }

    private static int loadTexturesForSpecies(BirdSpecies s, Path texDir) {
        int ok = 0;
        try {
            Files.list(texDir).forEach(p -> {
                String n = p.getFileName().toString().toLowerCase(Locale.ROOT);
                if (!n.endsWith(".png")) {
                    return;
                }
                ResourceLocation rl = BirdSpeciesLoader.registerRuntimeTexture(s, p);
                if (rl != null) {
                    s.textures.add(rl);
                }
            });
            ok = s.textures.size();
        }
        catch (Exception e) {
            JubitusBirds.LOGGER.warn("[JubitusBirds] Error reading textures for {}: {}", (Object)s.name, (Object)texDir.toAbsolutePath(), (Object)e);
        }
        return ok;
    }

    private static List<String> loadSoundsForPool(String speciesKey, String poolName, Path soundDir) {
        ArrayList<String> out = new ArrayList<String>();
        try {
            if (!Files.isDirectory(soundDir, new LinkOption[0])) {
                return out;
            }
            Files.list(soundDir).forEach(p -> {
                String n = p.getFileName().toString();
                String lower = n.toLowerCase(Locale.ROOT);
                if (!lower.endsWith(".ogg")) {
                    return;
                }
                String codec = BirdSpeciesLoader.detectOggCodec(p);
                if (!"vorbis".equals(codec)) {
                    long size = -1L;
                    try {
                        size = Files.size(p);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    JubitusBirds.LOGGER.error("[JubitusBirds] Skipping {} sound for default_species='{}' file={} (codec={}, {} bytes). Minecraft 1.12 needs VORBIS.", (Object)poolName, (Object)speciesKey, (Object)p.toAbsolutePath(), (Object)codec, (Object)size);
                    return;
                }
                String noExt = n.substring(0, n.length() - 4);
                noExt = noExt.replaceAll("[^a-zA-Z0-9_\\-\\.]", "_");
                out.add(noExt);
            });
        }
        catch (Exception e) {
            JubitusBirds.LOGGER.warn("[JubitusBirds] Error reading {} sounds for speciesKey='{}' dir={} err={}", (Object)poolName, (Object)speciesKey, (Object)soundDir.toAbsolutePath(), (Object)e.getMessage());
        }
        return out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ResourceLocation registerRuntimeTexture(BirdSpecies s, Path pngPath) {
        try (InputStream in = Files.newInputStream(pngPath, new OpenOption[0]);){
            BufferedImage img = TextureUtil.func_177053_a((InputStream)in);
            if (img == null) {
                JubitusBirds.LOGGER.warn("[JubitusBirds] '{}' is not a readable PNG (TextureUtil returned null).", (Object)pngPath.getFileName());
                ResourceLocation resourceLocation2 = null;
                return resourceLocation2;
            }
            DynamicTexture dyn = new DynamicTexture(img);
            String safeSpecies = s.name.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9_\\-]", "_");
            String safeFile = pngPath.getFileName().toString().toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9_\\-\\.]", "_");
            ResourceLocation rl = new ResourceLocation("jubitusbirds", "jubitusbirds/" + safeSpecies + "/" + safeFile);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(rl, (ITextureObject)dyn);
            ResourceLocation resourceLocation = rl;
            return resourceLocation;
        }
        catch (Exception e) {
            JubitusBirds.LOGGER.warn("[JubitusBirds] Failed loading texture: {}", (Object)pngPath.toAbsolutePath(), (Object)e);
            return null;
        }
    }

    private static String detectOggCodec(Path file) {
        try {
            int n;
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                return "not_a_file";
            }
            long size = Files.size(file);
            if (size < 64L) {
                return "too_small";
            }
            byte[] buf = new byte[4096];
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file.toFile()));){
                n = ((InputStream)in).read(buf);
            }
            if (n <= 0) {
                return "unreadable";
            }
            if (buf[0] != 79 || buf[1] != 103 || buf[2] != 103 || buf[3] != 83) {
                return "not_ogg_container";
            }
            String s = new String(buf, 0, n, StandardCharsets.ISO_8859_1);
            if (s.contains("vorbis")) {
                return "vorbis";
            }
            if (s.contains("OpusHead")) {
                return "opus";
            }
            if (s.contains("Speex")) {
                return "speex";
            }
            if (s.contains("FLAC")) {
                return "flac_in_ogg";
            }
            return "unknown_ogg_codec";
        }
        catch (Exception e) {
            return "error:" + e.getClass().getSimpleName();
        }
    }
}

