/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.species;

import com.jubitus.birds.species.BirdSpecies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;

public class BirdSpeciesRegistry {
    private static final Map<String, BirdSpecies> BY_NAME = new LinkedHashMap<String, BirdSpecies>();

    public static void clear() {
        BY_NAME.clear();
    }

    public static void register(BirdSpecies s) {
        BY_NAME.put(s.name.toLowerCase(Locale.ROOT), s);
    }

    public static Collection<BirdSpecies> all() {
        return BY_NAME.values();
    }

    public static BirdSpecies pickForBiome(Biome biome, Random rng, boolean isDay) {
        if (biome == null) {
            return null;
        }
        String biomeId = biome.getRegistryName() != null ? biome.getRegistryName().toString() : "";
        ArrayList<BirdSpecies> allowed = new ArrayList<BirdSpecies>();
        double totalW = 0.0;
        for (BirdSpecies s : BY_NAME.values()) {
            if (s == null || !s.enabled || !BirdSpeciesRegistry.isBiomeAllowed(s, biome) || s.spawnWeight <= 0.0 || isDay && !s.canSpawnAtDay || !isDay && !s.canSpawnAtNight) continue;
            allowed.add(s);
            totalW += s.spawnWeight;
        }
        if (allowed.isEmpty()) {
            return null;
        }
        double roll = rng.nextDouble() * totalW;
        for (BirdSpecies s : allowed) {
            if (!((roll -= s.spawnWeight) <= 0.0)) continue;
            return s;
        }
        return (BirdSpecies)allowed.get(allowed.size() - 1);
    }

    private static boolean isBiomeAllowed(BirdSpecies s, Biome biome) {
        Biome.TempCategory cat;
        String biomeId;
        if (biome == null) {
            return false;
        }
        String string = biomeId = biome.getRegistryName() != null ? biome.getRegistryName().toString() : "";
        if (s.resolvedBlacklistIds != null && s.resolvedBlacklistIds.contains(biomeId)) {
            return false;
        }
        if (s.resolvedWhitelistIds != null && !s.resolvedWhitelistIds.isEmpty() && !s.resolvedWhitelistIds.contains(biomeId)) {
            return false;
        }
        BirdSpecies.BiomeRules r = s.biomeRules;
        if (r == null) {
            return true;
        }
        float temp = biome.func_185353_n();
        if (r.temperatureMin != null && (double)temp < r.temperatureMin) {
            return false;
        }
        if (r.temperatureMax != null && (double)temp > r.temperatureMax) {
            return false;
        }
        if (r.resolvedTempCats != null && !r.resolvedTempCats.isEmpty() && !r.resolvedTempCats.contains(cat = biome.func_150561_m())) {
            return false;
        }
        if (r.requiresRain != null) {
            boolean canRain = biome.func_76738_d();
            if (r.requiresRain != canRain) {
                return false;
            }
        }
        if (r.requiresSnow != null) {
            boolean snow = biome.func_76746_c();
            if (r.requiresSnow != snow) {
                return false;
            }
        }
        if (r.requiresOceanic != null) {
            boolean isOcean = BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN);
            if (r.requiresOceanic != isOcean) {
                return false;
            }
        }
        if (r.resolvedBiomeManagerTypes != null && !r.resolvedBiomeManagerTypes.isEmpty()) {
            boolean ok = false;
            for (BiomeManager.BiomeType biomeType : r.resolvedBiomeManagerTypes) {
                if (BiomeManager.isTypeListModded((BiomeManager.BiomeType)biomeType)) {
                    // empty if block
                }
                if (!BiomeManager.getBiomes((BiomeManager.BiomeType)biomeType).stream().anyMatch(e -> e.biome == biome)) continue;
                ok = true;
                break;
            }
            if (!ok) {
                return false;
            }
        }
        if (r.resolvedDictBlacklist != null && !r.resolvedDictBlacklist.isEmpty()) {
            for (BiomeDictionary.Type t : r.resolvedDictBlacklist) {
                if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)t)) continue;
                return false;
            }
        }
        if (r.resolvedDictWhitelist != null && !r.resolvedDictWhitelist.isEmpty()) {
            boolean ok = false;
            for (BiomeDictionary.Type type : r.resolvedDictWhitelist) {
                if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type)) continue;
                ok = true;
                break;
            }
            return ok;
        }
        return true;
    }
}

