/*
 * Decompiled with CFR 0.152.
 */
package com.jubitus.birds.species;

import com.jubitus.birds.JubitusBirds;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public final class DefaultSpeciesExtractor {
    private static final String JAR_PREFIX = "assets/jubitusbirds/default_species/";

    private DefaultSpeciesExtractor() {
    }

    public static void extractMissingDefaults(FMLPreInitializationEvent event) {
        try {
            File cfgDir = event.getModConfigurationDirectory();
            Path targetRoot = cfgDir.toPath().resolve("jubitusbirds").resolve("default_species");
            Files.createDirectories(targetRoot, new FileAttribute[0]);
            File source = event.getSourceFile();
            if (source.isFile() && source.getName().endsWith(".jar")) {
                DefaultSpeciesExtractor.extractFromJar(source, targetRoot);
            } else if (source.isDirectory()) {
                DefaultSpeciesExtractor.extractFromDirectory(source.toPath(), targetRoot);
            } else {
                JubitusBirds.LOGGER.warn("[JubitusBirds] Unknown source type: {}", (Object)source);
            }
        }
        catch (Exception e) {
            JubitusBirds.LOGGER.warn("[JubitusBirds] Failed extracting default default_species.", (Throwable)e);
        }
    }

    private static void extractFromJar(File jarFile, Path targetRoot) throws Exception {
        try (JarFile jar = new JarFile(jarFile);){
            HashSet<String> bundledSpecies = new HashSet<String>();
            Enumeration<JarEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                String rest;
                int slash;
                String name;
                JarEntry je = en.nextElement();
                if (je.isDirectory() || !(name = je.getName()).startsWith(JAR_PREFIX) || (slash = (rest = name.substring(JAR_PREFIX.length())).indexOf(47)) <= 0) continue;
                String speciesFolder = rest.substring(0, slash);
                bundledSpecies.add(speciesFolder);
            }
            for (String speciesFolder : bundledSpecies) {
                Path outDir = targetRoot.resolve(speciesFolder);
                if (Files.isDirectory(outDir, new LinkOption[0])) {
                    JubitusBirds.LOGGER.info("[JubitusBirds] Default default_species '{}' already exists, skipping.", (Object)speciesFolder);
                    continue;
                }
                Files.createDirectories(outDir, new FileAttribute[0]);
                Enumeration<JarEntry> en2 = jar.entries();
                while (en2.hasMoreElements()) {
                    String prefix;
                    String name;
                    JarEntry je = en2.nextElement();
                    if (je.isDirectory() || !(name = je.getName()).startsWith(prefix = JAR_PREFIX + speciesFolder + "/")) continue;
                    String rel = name.substring(prefix.length());
                    Path outFile = outDir.resolve(rel);
                    Files.createDirectories(outFile.getParent(), new FileAttribute[0]);
                    InputStream in = jar.getInputStream(je);
                    Throwable throwable = null;
                    try {
                        Files.copy(in, outFile, new CopyOption[0]);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                JubitusBirds.LOGGER.info("[JubitusBirds] Installed default default_species '{}'.", (Object)speciesFolder);
            }
        }
    }

    private static void extractFromDirectory(Path modRoot, Path targetRoot) throws Exception {
        Path assets = DefaultSpeciesExtractor.findAssetsRoot(modRoot).resolve("jubitusbirds").resolve("default_species");
        if (!Files.isDirectory(assets, new LinkOption[0])) {
            JubitusBirds.LOGGER.warn("[JubitusBirds] No default_species folder found in dev resources: {}", (Object)assets);
            return;
        }
        try (Stream<Path> speciesDirs = Files.list(assets);){
            speciesDirs.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(speciesDir -> {
                String speciesFolder = speciesDir.getFileName().toString();
                Path outDir = targetRoot.resolve(speciesFolder);
                if (Files.isDirectory(outDir, new LinkOption[0])) {
                    JubitusBirds.LOGGER.info("[JubitusBirds] Default default_species '{}' already exists, skipping.", (Object)speciesFolder);
                    return;
                }
                try {
                    Files.createDirectories(outDir, new FileAttribute[0]);
                    Files.walk(speciesDir, new FileVisitOption[0]).forEach(p -> {
                        try {
                            if (Files.isDirectory(p, new LinkOption[0])) {
                                return;
                            }
                            Path rel = speciesDir.relativize((Path)p);
                            Path outFile = outDir.resolve(rel);
                            Files.createDirectories(outFile.getParent(), new FileAttribute[0]);
                            Files.copy(p, outFile, new CopyOption[0]);
                        }
                        catch (Exception ex) {
                            JubitusBirds.LOGGER.warn("[JubitusBirds] Failed copying default file {}", p, (Object)ex);
                        }
                    });
                    JubitusBirds.LOGGER.info("[JubitusBirds] Installed default default_species '{}'.", (Object)speciesFolder);
                }
                catch (Exception e) {
                    JubitusBirds.LOGGER.warn("[JubitusBirds] Failed installing default default_species '{}'.", (Object)speciesFolder, (Object)e);
                }
            });
        }
    }

    private static Path findAssetsRoot(Path from) {
        Path[] candidates;
        for (Path c : candidates = new Path[]{from.resolve("assets"), from.resolve("resources").resolve("main").resolve("assets"), from.resolve("build").resolve("resources").resolve("main").resolve("assets"), from.getParent() != null ? from.getParent().resolve("resources").resolve("main").resolve("assets") : null, from.getParent() != null ? from.getParent().resolve("build").resolve("resources").resolve("main").resolve("assets") : null}) {
            if (c == null || !Files.isDirectory(c, new LinkOption[0])) continue;
            return c;
        }
        Path cur = from;
        for (int i = 0; i < 6 && cur != null; cur = cur.getParent(), ++i) {
            Path a = cur.resolve("assets");
            if (!Files.isDirectory(a, new LinkOption[0])) continue;
            return a;
        }
        return from.resolve("assets");
    }
}

