/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.compat.jei;

import de.ellpeck.prettypipes.packets.PacketGhostSlot;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalGui;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class JEICraftingTerminalGhostIngredients
implements IGhostIngredientHandler<CraftingTerminalGui> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(CraftingTerminalGui gui, ITypedIngredient<I> ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targetList = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (int i = 0; i < 9; ++i) {
            GhostSlotTarget currentTarget = new GhostSlotTarget(i, gui);
            targetList.add(currentTarget);
        }
        return targetList;
    }

    public void onComplete() {
    }

    public static class GhostSlotTarget
    implements IGhostIngredientHandler.Target<ItemStack> {
        private final int curSlotIndex;
        private final CraftingTerminalGui gui;
        private final Slot curSlot;

        public GhostSlotTarget(int curSlotIndex, CraftingTerminalGui gui) {
            this.curSlotIndex = curSlotIndex;
            this.gui = gui;
            this.curSlot = ((ItemTerminalContainer)gui.getMenu()).getSlot(curSlotIndex + 1);
        }

        public Rect2i getArea() {
            return new Rect2i(this.gui.getGuiLeft() + this.curSlot.x, this.gui.getGuiTop() + this.curSlot.y, 16, 16);
        }

        public void accept(ItemStack ingredient) {
            ItemTerminalBlockEntity itemTerminalBlockEntity = ((ItemTerminalContainer)this.gui.getMenu()).tile;
            if (itemTerminalBlockEntity instanceof CraftingTerminalBlockEntity) {
                CraftingTerminalBlockEntity craftingTerminalBlockEntity = (CraftingTerminalBlockEntity)itemTerminalBlockEntity;
                ItemStack ghostStack = ingredient.copyWithCount(1);
                ArrayList<PacketGhostSlot.Entry> stacks = new ArrayList<PacketGhostSlot.Entry>();
                for (int i = 0; i < craftingTerminalBlockEntity.craftItems.getSlots(); ++i) {
                    if (i != this.curSlotIndex) {
                        stacks.add(i, new PacketGhostSlot.Entry(Optional.of(List.of(craftingTerminalBlockEntity.ghostItems.getStackInSlot(i))), Optional.empty()));
                        continue;
                    }
                    stacks.add(i, new PacketGhostSlot.Entry(Optional.of(List.of(ghostStack)), Optional.empty()));
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketGhostSlot(craftingTerminalBlockEntity.getBlockPos(), stacks), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

