/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.compat.jei;

import de.ellpeck.prettypipes.misc.FilterSlot;
import de.ellpeck.prettypipes.misc.ItemFilter;
import de.ellpeck.prettypipes.packets.PacketFilterSlot;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeGui;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class JEIFilterGhostIngredients
implements IGhostIngredientHandler<AbstractPipeGui> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(AbstractPipeGui gui, ITypedIngredient<I> ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targetList = new ArrayList<IGhostIngredientHandler.Target<I>>();
        if (gui.getMenu() instanceof ItemFilter.IFilteredContainer) {
            for (Slot slot : gui.getMenu().slots) {
                if (!(slot instanceof FilterSlot)) continue;
                targetList.add(new GhostTarget(gui, slot));
            }
        }
        return targetList;
    }

    public void onComplete() {
    }

    public static class GhostTarget
    implements IGhostIngredientHandler.Target<ItemStack> {
        private final Slot slot;
        private final AbstractPipeGui gui;

        public GhostTarget(AbstractPipeGui gui, Slot slot) {
            this.slot = slot;
            this.gui = gui;
        }

        public Rect2i getArea() {
            return new Rect2i(this.gui.getGuiLeft() + this.slot.x, this.gui.getGuiTop() + this.slot.y, 16, 16);
        }

        public void accept(ItemStack ingredient) {
            if (ingredient.isEmpty() || !(this.slot instanceof FilterSlot)) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new PacketFilterSlot(this.slot.index, ingredient), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

