/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.compat.jei;

import de.ellpeck.prettypipes.compat.jei.CraftingModuleTransferHandler;
import de.ellpeck.prettypipes.compat.jei.CraftingTerminalTransferHandler;
import de.ellpeck.prettypipes.compat.jei.JEICraftingTerminalGhostIngredients;
import de.ellpeck.prettypipes.compat.jei.JEICraftingTerminalGuiElementHandler;
import de.ellpeck.prettypipes.compat.jei.JEIFilterGhostIngredients;
import de.ellpeck.prettypipes.misc.PlayerPrefs;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeGui;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalGui;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;

@JeiPlugin
public class JEIPrettyPipesPlugin
implements IModPlugin {
    private IJeiRuntime runtime;
    private String lastTerminalText;
    private String lastJeiText;
    private Button jeiSyncButton;

    public JEIPrettyPipesPlugin() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"prettypipes", (String)"jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        this.runtime = jeiRuntime;
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingTerminalTransferHandler(), RecipeTypes.CRAFTING);
        registration.addUniversalRecipeTransferHandler((IUniversalRecipeTransferHandler)new CraftingModuleTransferHandler());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(ItemTerminalGui.class, (IGuiContainerHandler)new JEICraftingTerminalGuiElementHandler());
        registration.addGhostIngredientHandler(CraftingTerminalGui.class, (IGhostIngredientHandler)new JEICraftingTerminalGhostIngredients());
        registration.addGhostIngredientHandler(AbstractPipeGui.class, (IGhostIngredientHandler)new JEIFilterGhostIngredients());
    }

    @SubscribeEvent
    public void onInitGui(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof ItemTerminalGui)) {
            return;
        }
        ItemTerminalGui terminal = (ItemTerminalGui)screen;
        this.jeiSyncButton = Button.builder((Component)Component.literal((String)""), button -> {
            PlayerPrefs preferences = PlayerPrefs.get();
            preferences.syncJei = !preferences.syncJei;
            preferences.save();
            terminal.updateWidgets();
        }).bounds(terminal.getGuiLeft() - 22, terminal.getGuiTop() + 44, 20, 20).build();
        terminal.addRenderableWidget(this.jeiSyncButton);
        if (PlayerPrefs.get().syncJei) {
            terminal.search.setValue(this.runtime.getIngredientFilter().getFilterText());
        }
    }

    @SubscribeEvent
    public void onRenderGuiPre(ScreenEvent.Render.Pre event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof ItemTerminalGui)) {
            return;
        }
        boolean sync = PlayerPrefs.get().syncJei;
        this.jeiSyncButton.setMessage((Component)Component.literal((String)(String.valueOf(sync ? ChatFormatting.GREEN : ChatFormatting.RED) + "J")));
    }

    @SubscribeEvent
    public void onRenderGuiPost(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof ItemTerminalGui)) {
            return;
        }
        ItemTerminalGui terminal = (ItemTerminalGui)screen;
        boolean sync = PlayerPrefs.get().syncJei;
        if (this.jeiSyncButton.isHovered()) {
            event.getGuiGraphics().renderTooltip(terminal.getMinecraft().font, (Component)Component.translatable((String)("info.prettypipes.sync_jei." + (sync ? "on" : "off"))), event.getMouseX(), event.getMouseY());
        }
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre event) {
        if (!PlayerPrefs.get().syncJei) {
            return;
        }
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof ItemTerminalGui)) {
            this.lastTerminalText = null;
            this.lastJeiText = null;
            return;
        }
        ItemTerminalGui terminal = (ItemTerminalGui)screen;
        IIngredientFilter filter = this.runtime.getIngredientFilter();
        String terminalText = terminal.search.getValue();
        String jeiText = filter.getFilterText();
        if (!jeiText.equals(this.lastJeiText)) {
            this.lastTerminalText = jeiText;
            this.lastJeiText = jeiText;
            terminal.search.setValue(jeiText);
        } else if (!terminalText.equals(this.lastTerminalText)) {
            this.lastTerminalText = terminalText;
            this.lastJeiText = terminalText;
            filter.setFilterText(terminalText);
        }
    }
}

