/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.entities;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;

public class PipeFrameEntity
extends ItemFrame
implements IEntityWithComplexSpawn {
    private static final EntityDataAccessor<Integer> AMOUNT = SynchedEntityData.defineId(PipeFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public PipeFrameEntity(EntityType<PipeFrameEntity> type, Level world) {
        super(type, world);
    }

    public PipeFrameEntity(EntityType<PipeFrameEntity> type, Level world, BlockPos pos, Direction dir) {
        this(type, world);
        this.pos = pos;
        this.setDirection(dir);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(AMOUNT, (Object)-1);
    }

    public void tick() {
        ItemStack stack;
        BlockPos node;
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        if (this.tickCount % 40 != 0) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(this.level());
        BlockPos attached = PipeFrameEntity.getAttachedPipe(this.level(), this.pos, this.direction);
        if (attached != null && (node = network.getNodeFromPipe(attached)) != null && !(stack = this.getItem()).isEmpty()) {
            List<NetworkLocation> items = network.getOrderedNetworkItems(node);
            int amount = items.stream().mapToInt(i -> i.getItemAmount(this.level(), stack, new ItemEquality[0])).sum();
            this.entityData.set(AMOUNT, (Object)amount);
            return;
        }
        this.entityData.set(AMOUNT, (Object)-1);
    }

    public boolean survives() {
        return super.survives() && PipeFrameEntity.canPlace(this.level(), this.pos, this.direction);
    }

    private static BlockPos getAttachedPipe(Level world, BlockPos pos, Direction direction) {
        for (int i = 1; i <= 2; ++i) {
            BlockPos offset = pos.relative(direction.getOpposite(), i);
            BlockState state = world.getBlockState(offset);
            if (!(state.getBlock() instanceof PipeBlock)) continue;
            return offset;
        }
        return null;
    }

    public static boolean canPlace(Level world, BlockPos pos, Direction direction) {
        return PipeFrameEntity.getAttachedPipe(world, pos, direction) != null;
    }

    public int getAmount() {
        return (Integer)this.entityData.get(AMOUNT);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!source.is(DamageTypeTags.IS_EXPLOSION) && !this.getItem().isEmpty()) {
            if (!this.level().isClientSide) {
                this.dropItemOrSelf(source.getDirectEntity(), false);
                this.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, 1.0f, 1.0f);
            }
            return true;
        }
        return super.hurt(source, amount);
    }

    public void dropItem(@Nullable Entity brokenEntity) {
        this.playSound(SoundEvents.ITEM_FRAME_BREAK, 1.0f, 1.0f);
        this.dropItemOrSelf(brokenEntity, true);
    }

    private void dropItemOrSelf(@Nullable Entity entityIn, boolean b) {
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            if (entityIn == null) {
                this.getItem().setEntityRepresentation(null);
            }
        } else {
            Player playerentity;
            ItemStack itemstack = this.getItem();
            this.setItem(ItemStack.EMPTY);
            if (entityIn instanceof Player && (playerentity = (Player)entityIn).isCreative()) {
                itemstack.setEntityRepresentation(null);
                return;
            }
            if (b) {
                this.spawnAtLocation((ItemLike)Registry.pipeFrameItem);
            }
            if (!itemstack.isEmpty()) {
                itemstack = itemstack.copy();
                itemstack.setEntityRepresentation(null);
                this.spawnAtLocation(itemstack);
            }
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.getItem().isEmpty()) {
            return super.interact(player, hand);
        }
        return InteractionResult.FAIL;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)Registry.pipeFrameItem);
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeInt(this.direction.ordinal());
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.pos = additionalData.readBlockPos();
        this.direction = Direction.values()[additionalData.readInt()];
    }
}

