/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.ellpeck.prettypipes.entities.PipeFrameEntity;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class PipeFrameRenderer
extends ItemFrameRenderer<PipeFrameEntity> {
    public PipeFrameRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(PipeFrameEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.render((ItemFrame)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.pushPose();
        Direction direction = entityIn.getDirection();
        Vec3 vec3d = this.getRenderOffset(entityIn, partialTicks);
        matrixStackIn.translate(-vec3d.x, -vec3d.y, -vec3d.z);
        matrixStackIn.translate((double)direction.getStepX() * 0.46875, (double)direction.getStepY() * 0.46875, (double)direction.getStepZ() * 0.46875);
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(entityIn.getXRot()));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f - entityIn.getYRot()));
        Font font = this.getFont();
        int amount = entityIn.getAmount();
        String amountStrg = amount < 0 ? "?" : String.valueOf(amount);
        float x = 0.5f - (float)font.width(amountStrg) / 2.0f;
        Matrix4f matrix4f = matrixStackIn.last().pose();
        matrixStackIn.translate(0.0f, 0.285f, 0.415f);
        matrixStackIn.scale(-0.02f, -0.02f, 0.02f);
        font.drawInBatch(amountStrg, x, 0.0f, 0xFFFFFF, false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, 0, packedLightIn);
        matrixStackIn.popPose();
    }
}

