/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.items;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WrenchItem
extends Item {
    public WrenchItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack offhand;
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockState state = world.getBlockState(pos);
        if (!(state.getBlock() instanceof PipeBlock)) {
            return InteractionResult.PASS;
        }
        PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)world, pos);
        if (tile == null) {
            return InteractionResult.FAIL;
        }
        if (player.isCrouching()) {
            if (!world.isClientSide) {
                if (tile.cover != null) {
                    tile.removeCover();
                    Utility.sendBlockEntityToClients(tile);
                } else {
                    Block.dropResources((BlockState)state, (Level)world, (BlockPos)pos, (BlockEntity)tile, null, (ItemStack)ItemStack.EMPTY);
                    world.removeBlock(pos, false);
                }
                world.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        if (tile.cover == null && (offhand = player.getOffhandItem()).getItem() instanceof BlockItem) {
            if (!world.isClientSide) {
                BlockPlaceContext blockContext = new BlockPlaceContext(context);
                Block block = ((BlockItem)offhand.getItem()).getBlock();
                BlockState cover = block.getStateForPlacement(blockContext);
                if (cover != null && !(block instanceof EntityBlock)) {
                    tile.cover = cover;
                    Utility.sendBlockEntityToClients(tile);
                    offhand.shrink(1);
                    world.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        for (Map.Entry<Direction, VoxelShape> entry : PipeBlock.DIR_SHAPES.entrySet()) {
            EnumProperty<ConnectionType> prop;
            ConnectionType curr;
            AABB box = entry.getValue().bounds().move(pos).inflate((double)0.001f);
            if (!box.contains(context.getClickLocation()) || (curr = (ConnectionType)((Object)state.getValue(prop = PipeBlock.DIRECTIONS.get(entry.getKey())))) == ConnectionType.DISCONNECTED) continue;
            if (!world.isClientSide) {
                ConnectionType newType = curr == ConnectionType.BLOCKED ? ConnectionType.CONNECTED : ConnectionType.BLOCKED;
                BlockPos otherPos = pos.relative(entry.getKey());
                BlockState otherState = world.getBlockState(otherPos);
                if (otherState.getBlock() instanceof PipeBlock) {
                    otherState = (BlockState)otherState.setValue((Property)PipeBlock.DIRECTIONS.get(entry.getKey().getOpposite()), (Comparable)((Object)newType));
                    world.setBlockAndUpdate(otherPos, otherState);
                    PipeBlock.onStateChanged(world, otherPos, otherState);
                }
                BlockState newState = (BlockState)state.setValue(prop, (Comparable)((Object)newType));
                world.setBlockAndUpdate(pos, newState);
                PipeBlock.onStateChanged(world, pos, newState);
                world.playSound(null, pos, SoundEvents.ITEM_FRAME_ROTATE_ITEM, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        Utility.addTooltip(BuiltInRegistries.ITEM.getKey((Object)this).getPath(), pTooltipComponents);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 1;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment == Enchantments.SILK_TOUCH;
    }
}

