/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.apache.commons.lang3.ArrayUtils;

public class DirectionSelector {
    private static final Direction[] ALL = (Direction[])ArrayUtils.addAll((Object[])Direction.values(), (Object[])new Direction[]{null});
    private Direction direction;
    private boolean modified;
    private final ItemStack stack;
    private final PipeBlockEntity pipe;

    public DirectionSelector(ItemStack stack, PipeBlockEntity pipe) {
        this.stack = stack;
        this.pipe = pipe;
        this.load();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractWidget getButton(int x, int y) {
        return new ExtendedButton(x, y, 100, 20, (Component)Component.translatable((String)"info.prettypipes.populate"), button -> PacketButton.sendAndExecute(this.pipe.getBlockPos(), PacketButton.ButtonResult.DIRECTION_SELECTOR, List.of())){

            public Component getMessage() {
                PipeBlockEntity pipe = DirectionSelector.this.pipe;
                Direction dir = DirectionSelector.this.direction;
                MutableComponent msg = Component.translatable((String)("dir.prettypipes." + (dir != null ? dir.getName() : "all")));
                if (dir != null) {
                    MutableComponent blockName;
                    MutableComponent mutableComponent = blockName = pipe.getItemHandler(dir) != null ? pipe.getLevel().getBlockState(pipe.getBlockPos().relative(dir)).getBlock().getName() : null;
                    if (blockName != null) {
                        msg = msg.append(" (").append((Component)blockName).append(")");
                    }
                }
                return msg;
            }
        };
    }

    public void onButtonPacket() {
        Direction dir = this.direction;
        while (!this.isDirectionValid(dir = ALL[(ArrayUtils.indexOf((Object[])ALL, (Object)dir) + 1) % ALL.length])) {
        }
        if (this.direction != dir) {
            this.direction = dir;
            this.modified = true;
        }
    }

    public void save() {
        if (!this.modified) {
            return;
        }
        this.modified = false;
        this.stack.set(Data.TYPE, (Object)new Data(this.direction != null ? this.direction.getName() : ""));
    }

    public void load() {
        Data data = (Data)this.stack.get(Data.TYPE);
        if (data != null) {
            this.direction = !Strings.isNullOrEmpty((String)data.direction) ? Direction.byName((String)data.direction) : null;
        }
    }

    public Direction[] directions() {
        Direction[] directionArray;
        if (this.direction != null) {
            Direction[] directionArray2 = new Direction[1];
            directionArray = directionArray2;
            directionArray2[0] = this.direction;
        } else {
            directionArray = Direction.values();
        }
        return directionArray;
    }

    public boolean has(Direction dir) {
        return this.direction == null || this.direction == dir;
    }

    private boolean isDirectionValid(Direction dir) {
        if (dir == null) {
            return true;
        }
        if (this.pipe.getItemHandler(dir) == null) {
            return false;
        }
        return this.pipe.streamModules().filter(p -> p.getLeft() != this.stack).map(p -> ((IModule)p.getRight()).getDirectionSelector((ItemStack)p.getLeft(), this.pipe)).noneMatch(p -> p != null && p.direction == dir);
    }

    public record Data(String direction) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("direction").forGetter(f -> f.direction)).apply((Applicative)i, Data::new));
        public static final DataComponentType<Data> TYPE = DataComponentType.builder().persistent(CODEC).cacheEncoding().build();
    }

    public static interface IDirectionContainer {
        public DirectionSelector getSelector();
    }
}

