/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.network;

import com.mojang.datafixers.util.Either;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeNetwork;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class ActiveCraft
implements INBTSerializable<CompoundTag> {
    public BlockPos pipe;
    public int moduleSlot;
    public List<Either<NetworkLock, ItemStack>> ingredientsToRequest;
    public List<ItemStack> travelingIngredients;
    public BlockPos resultDestPipe;
    public ItemStack resultStackRemain;
    public boolean inProgress;
    public boolean resultFound;
    public boolean canceled;

    public ActiveCraft(BlockPos pipe, int moduleSlot, List<Either<NetworkLock, ItemStack>> ingredientsToRequest, List<ItemStack> travelingIngredients, BlockPos resultDestPipe, ItemStack resultStackRemain) {
        this.pipe = pipe;
        this.moduleSlot = moduleSlot;
        this.ingredientsToRequest = ingredientsToRequest;
        this.travelingIngredients = travelingIngredients;
        this.resultDestPipe = resultDestPipe;
        this.resultStackRemain = resultStackRemain;
    }

    public ActiveCraft(HolderLookup.Provider provider, CompoundTag tag) {
        this.deserializeNBT(provider, tag);
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag ret = new CompoundTag();
        ret.putLong("pipe", this.pipe.asLong());
        ret.putInt("module_slot", this.moduleSlot);
        ret.put("ingredients_to_request", (Tag)Utility.serializeAll(this.ingredientsToRequest, n -> {
            CompoundTag tag = new CompoundTag();
            n.ifLeft(l -> tag.put("lock", (Tag)l.serializeNBT(provider))).ifRight(s -> tag.put("stack", s.save(provider)));
            return tag;
        }));
        ret.put("traveling_ingredients", (Tag)Utility.serializeAll(this.travelingIngredients, s -> (CompoundTag)s.save(provider, (Tag)new CompoundTag())));
        ret.putLong("result_dest_pipe", this.resultDestPipe.asLong());
        ret.put("result_stack_remain", this.resultStackRemain.saveOptional(provider));
        ret.putBoolean("in_progress", this.inProgress);
        ret.putBoolean("result_found", this.resultFound);
        ret.putBoolean("canceled", this.canceled);
        return ret;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.pipe = BlockPos.of((long)nbt.getLong("pipe"));
        this.moduleSlot = nbt.getInt("module_slot");
        this.ingredientsToRequest = Utility.deserializeAll(nbt.getList("ingredients_to_request", 10), t -> t.contains("lock") ? Either.left((Object)new NetworkLock(provider, t.getCompound("lock"))) : Either.right((Object)ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)t.getCompound("stack"))));
        this.travelingIngredients = Utility.deserializeAll(nbt.getList("traveling_ingredients", 10), t -> (ItemStack)ItemStack.parse((HolderLookup.Provider)provider, (Tag)t).orElseThrow());
        this.resultDestPipe = BlockPos.of((long)nbt.getLong("result_dest_pipe"));
        this.resultStackRemain = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("result_stack_remain"));
        this.inProgress = nbt.getBoolean("in_progress");
        this.resultFound = nbt.getBoolean("result_found");
        this.canceled = nbt.getBoolean("canceled");
    }

    public String toString() {
        return "ActiveCraft{pipe=" + String.valueOf(this.pipe) + ", moduleSlot=" + this.moduleSlot + ", travelingIngredients=" + String.valueOf(this.travelingIngredients) + ", ingredientsToRequest=" + String.valueOf(this.ingredientsToRequest) + ", resultDestPipe=" + String.valueOf(this.resultDestPipe) + ", resultStackRemain=" + String.valueOf(this.resultStackRemain) + ", inProgress=" + this.inProgress + ", resultFound=" + this.resultFound + ", canceled=" + this.canceled + "}";
    }

    public ItemStack getTravelingIngredient(ItemStack stack, ItemEquality ... equalityTypes) {
        for (ItemStack traveling : this.travelingIngredients) {
            if (!ItemEquality.compareItems(stack, traveling, equalityTypes)) continue;
            return traveling;
        }
        return ItemStack.EMPTY;
    }

    public boolean markCanceledOrResolve(PipeNetwork network, boolean force) {
        if (force || !this.inProgress) {
            for (Either<NetworkLock, ItemStack> lock : this.ingredientsToRequest) {
                lock.ifLeft(network::resolveNetworkLock);
            }
            return true;
        }
        this.canceled = true;
        return false;
    }
}

