/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.network;

import de.ellpeck.prettypipes.network.NetworkLocation;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class NetworkLock
implements INBTSerializable<CompoundTag> {
    private UUID lockId = UUID.randomUUID();
    public NetworkLocation location;
    public ItemStack stack;

    public NetworkLock(NetworkLocation location, ItemStack stack) {
        this.location = location;
        this.stack = stack;
    }

    public NetworkLock(HolderLookup.Provider provider, CompoundTag nbt) {
        this.deserializeNBT(provider, nbt);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putUUID("id", this.lockId);
        nbt.put("location", (Tag)this.location.serializeNBT(provider));
        nbt.put("stack", this.stack.save(provider));
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.lockId = nbt.getUUID("id");
        this.location = new NetworkLocation(provider, nbt.getCompound("location"));
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("stack"));
    }

    public boolean equals(Object o) {
        if (o instanceof NetworkLock) {
            NetworkLock that = (NetworkLock)o;
            return this.lockId.equals(that.lockId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.lockId);
    }

    public String toString() {
        return "NetworkLock{location=" + String.valueOf(this.location.pipePos) + ", stack=" + String.valueOf(this.stack) + "}";
    }
}

