/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketItemEnterPipe(BlockPos tilePos, CompoundTag item) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketItemEnterPipe> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"prettypipes", (String)"item_enter_pipe"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketItemEnterPipe> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketItemEnterPipe::tilePos, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, PacketItemEnterPipe::item, PacketItemEnterPipe::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void onMessage(PacketItemEnterPipe message, IPayloadContext ctx) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        IPipeItem item = IPipeItem.load((HolderLookup.Provider)mc.level.registryAccess(), message.item);
        PipeBlockEntity pipe = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)mc.level, message.tilePos);
        if (pipe != null) {
            pipe.getItems().add(item);
        }
    }
}

