/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.containers;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.misc.FilterSlot;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractPipeContainer<T extends IModule>
extends AbstractContainerMenu {
    public final PipeBlockEntity tile;
    public final T module;
    public final int moduleIndex;
    public final ItemStack moduleStack;

    public AbstractPipeContainer(@Nullable MenuType<?> type, int id, Player player, BlockPos pos, int moduleIndex) {
        super(type, id);
        this.tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)player.level(), pos);
        this.moduleStack = moduleIndex < 0 ? null : this.tile.modules.getStackInSlot(moduleIndex);
        this.module = moduleIndex < 0 ? null : (IModule)this.moduleStack.getItem();
        this.moduleIndex = moduleIndex;
        this.addSlots();
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)player.getInventory(), j1 + l * 9 + 9, 8 + j1 * 18, 89 + l * 18 + 32));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)player.getInventory(), i1, 8 + i1 * 18, 179));
        }
    }

    protected abstract void addSlots();

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        return Utility.transferStackInSlot(this, (x$0, x$1, x$2, x$3) -> this.moveItemStackTo(x$0, x$1, x$2, x$3), player, slotIndex, stack -> {
            if (stack.getItem() instanceof IModule) {
                return Pair.of((Object)0, (Object)3);
            }
            return null;
        });
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (FilterSlot.checkFilter(this, slotId)) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

