/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pressurizer;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pressurizer.PressurizerContainer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;

public class PressurizerBlockEntity
extends BlockEntity
implements MenuProvider,
IPipeConnectable {
    public final ModifiableEnergyStorage storage = new ModifiableEnergyStorage(64000, 512, 0);
    private int lastEnergy;

    public PressurizerBlockEntity(BlockPos pos, BlockState state) {
        super(Registry.pressurizerBlockEntity, pos, state);
    }

    public boolean pressurizeItem(ItemStack stack, boolean simulate) {
        int amount = 100 * stack.getCount();
        return this.storage.extractInternal(amount, simulate) >= amount;
    }

    public float getEnergyPercentage() {
        return (float)this.getEnergy() / (float)this.getMaxEnergy();
    }

    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergy() {
        return this.storage.getMaxEnergyStored();
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("energy", this.getEnergy());
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.storage.setEnergyStored(nbt.getInt("energy"));
        super.loadAdditional(nbt, provider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        this.loadWithComponents(tag, provider);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        this.loadWithComponents(pkt.getTag(), provider);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.prettypipes.pressurizer");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int window, Inventory inv, Player player) {
        return new PressurizerContainer(Registry.pressurizerContainer, window, player, this.worldPosition);
    }

    @Override
    public ConnectionType getConnectionType(BlockPos pipePos, Direction direction) {
        return ConnectionType.CONNECTED;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PressurizerBlockEntity pressurizer) {
        if (pressurizer.level.getGameTime() % 10L == 0L) {
            PipeNetwork network = PipeNetwork.get(pressurizer.level);
            for (Direction dir : Direction.values()) {
                BlockPos offset = pressurizer.worldPosition.relative(dir);
                for (BlockPos node : network.getOrderedNetworkNodes(offset)) {
                    PipeBlockEntity pipe;
                    if (!pressurizer.level.isLoaded(node) || (pipe = network.getPipe(node)) == null) continue;
                    pipe.pressurizer = pressurizer;
                }
            }
        }
        if (pressurizer.lastEnergy != pressurizer.storage.getEnergyStored() && pressurizer.level.getGameTime() % 10L == 0L) {
            pressurizer.lastEnergy = pressurizer.storage.getEnergyStored();
            level.updateNeighbourForOutputSignal(pos, state.getBlock());
            Utility.sendBlockEntityToClients(pressurizer);
        }
    }

    public static class ModifiableEnergyStorage
    extends EnergyStorage {
        public ModifiableEnergyStorage(int capacity, int maxReceive, int maxExtract) {
            super(capacity, maxReceive, maxExtract);
        }

        private void setEnergyStored(int energy) {
            this.energy = energy;
        }

        private int extractInternal(int maxExtract, boolean simulate) {
            int energyExtracted = Math.min(this.energy, maxExtract);
            if (!simulate) {
                this.energy -= energyExtracted;
            }
            return energyExtracted;
        }
    }
}

