/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal.containers;

import com.mojang.blaze3d.platform.InputConstants;
import de.ellpeck.prettypipes.misc.ItemTerminalWidget;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.packets.PacketGhostSlot;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class CraftingTerminalGui
extends ItemTerminalGui {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"prettypipes", (String)"textures/gui/crafting_terminal.png");
    private Button requestButton;
    private Button sendBackButton;
    private ItemTerminalWidget draggedItem;
    private double initialDragX;
    private double initialDragY;
    private boolean dragging;

    public CraftingTerminalGui(ItemTerminalContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.imageWidth = 256;
    }

    @Override
    protected void init() {
        super.init();
        this.requestButton = this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"info.prettypipes.request"), button -> {
            int amount = ItemTerminalGui.requestModifier();
            int force = Screen.hasAltDown() || InputConstants.isKeyDown((long)this.minecraft.getWindow().getWindow(), (int)259) ? 1 : 0;
            PacketDistributor.sendToServer((CustomPacketPayload)new PacketButton(((ItemTerminalContainer)this.menu).tile.getBlockPos(), PacketButton.ButtonResult.CRAFT_TERMINAL_REQUEST, Arrays.asList(amount, force)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }).bounds(this.leftPos + 8, this.topPos + 100, 50, 20).build());
        this.sendBackButton = this.addRenderableWidget(Button.builder((Component)Component.literal((String)">"), button -> PacketDistributor.sendToServer((CustomPacketPayload)new PacketButton(((ItemTerminalContainer)this.menu).tile.getBlockPos(), PacketButton.ButtonResult.CRAFT_TERMINAL_SEND_BACK, List.of()), (CustomPacketPayload[])new CustomPacketPayload[0])).bounds(this.leftPos + 47, this.topPos + 72, 12, 12).build());
        this.tick();
    }

    @Override
    public void containerTick() {
        super.containerTick();
        CraftingTerminalBlockEntity tile = this.getCraftingContainer().getTile();
        this.requestButton.active = false;
        this.sendBackButton.active = false;
        for (int i = 0; i < tile.craftItems.getSlots(); ++i) {
            ItemStack realStack;
            ItemStack requestStack = tile.getRequestedCraftItem(i);
            if (!requestStack.isEmpty() && requestStack.getCount() < requestStack.getMaxStackSize()) {
                this.requestButton.active = true;
            }
            if ((realStack = tile.craftItems.getStackInSlot(i)).isEmpty()) continue;
            this.sendBackButton.active = true;
        }
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        CraftingTerminalContainer container = this.getCraftingContainer();
        CraftingTerminalBlockEntity tile = container.getTile();
        for (int i = 0; i < tile.ghostItems.getSlots(); ++i) {
            ItemStack ghost;
            if (!tile.craftItems.getStackInSlot(i).isEmpty() || (ghost = tile.ghostItems.getStackInSlot(i)).isEmpty()) continue;
            int finalI = i;
            Slot slot = container.slots.stream().filter(s -> s.container == container.craftInventory && s.getSlotIndex() == finalI).findFirst().orElse(null);
            if (slot == null) continue;
            graphics.renderItem(ghost, slot.x, slot.y);
            graphics.renderItemDecorations(this.font, ghost, slot.x, slot.y, "0");
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggedItem == null) {
            this.getChildAt(mouseX, mouseY).ifPresent(arg_0 -> this.lambda$mouseClicked$3(mouseX, mouseY, arg_0));
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int i, double j, double k) {
        if (!this.dragging && this.draggedItem != null && Mth.lengthSquared((double)(mouseX - this.initialDragX), (double)(mouseY - this.initialDragY)) >= 4.0) {
            this.dragging = true;
        }
        return super.mouseDragged(mouseX, mouseY, i, j, k);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        Slot curSlot = this.getSlotUnderMouse();
        if (this.draggedItem != null && !this.draggedItem.stack.isEmpty() && curSlot != null && curSlot.index >= 0 && curSlot.index <= 9) {
            ItemStack ghostStack = this.draggedItem.stack.copyWithCount(1);
            ArrayList<PacketGhostSlot.Entry> stacks = new ArrayList<PacketGhostSlot.Entry>();
            ItemTerminalBlockEntity itemTerminalBlockEntity = ((ItemTerminalContainer)this.menu).tile;
            if (itemTerminalBlockEntity instanceof CraftingTerminalBlockEntity) {
                CraftingTerminalBlockEntity craftingTerminalBlockEntity = (CraftingTerminalBlockEntity)itemTerminalBlockEntity;
                for (int i = 0; i < craftingTerminalBlockEntity.ghostItems.getSlots(); ++i) {
                    if (i != curSlot.index - 1) {
                        stacks.add(i, new PacketGhostSlot.Entry(Optional.of(List.of(craftingTerminalBlockEntity.ghostItems.getStackInSlot(i))), Optional.empty()));
                        continue;
                    }
                    stacks.add(i, new PacketGhostSlot.Entry(Optional.of(List.of(ghostStack)), Optional.empty()));
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketGhostSlot(craftingTerminalBlockEntity.getBlockPos(), stacks), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        this.draggedItem = null;
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.dragging && this.draggedItem != null) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 200.0f);
            graphics.renderItem(this.draggedItem.stack, mouseX - 9, mouseY - 9);
            graphics.pose().popPose();
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected int getXOffset() {
        return 65;
    }

    protected CraftingTerminalContainer getCraftingContainer() {
        return (CraftingTerminalContainer)this.menu;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$mouseClicked$3(double mouseX, double mouseY, GuiEventListener child) {
        if (!(child instanceof ItemTerminalWidget)) ** GOTO lbl-1000
        widget = (ItemTerminalWidget)child;
        if (!widget.stack.isEmpty()) {
            v0 = widget;
        } else lbl-1000:
        // 2 sources

        {
            v0 = null;
        }
        this.draggedItem = v0;
        this.initialDragX = mouseX;
        this.initialDragY = mouseY;
    }
}

