/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal.containers;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ItemTerminalContainer
extends AbstractContainerMenu {
    public final ItemTerminalBlockEntity tile;

    public ItemTerminalContainer(@Nullable MenuType<?> type, int id, Player player, BlockPos pos) {
        super(type, id);
        this.tile = Utility.getBlockEntity(ItemTerminalBlockEntity.class, (BlockGetter)player.level(), pos);
        this.addOwnSlots(player);
        int off = this.getSlotXOffset();
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)player.getInventory(), j1 + l * 9 + 9, 8 + off + j1 * 18, 154 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)player.getInventory(), i1, 8 + off + i1 * 18, 212));
        }
    }

    protected void addOwnSlots(Player player) {
        int i;
        int off = this.getSlotXOffset();
        for (i = 0; i < 6; ++i) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.tile.items, i, 8 + off + i % 3 * 18, 102 + i / 3 * 18));
        }
        for (i = 0; i < 6; ++i) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.tile.items, i + 6, 116 + off + i % 3 * 18, 102 + i / 3 * 18));
        }
    }

    protected int getSlotXOffset() {
        return 0;
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        return Utility.transferStackInSlot(this, (x$0, x$1, x$2, x$3) -> this.moveItemStackTo(x$0, x$1, x$2, x$3), player, slotIndex, stack -> Pair.of((Object)6, (Object)12));
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

