/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal.containers;

import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalContainer;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class WrappedCraftingInventory
implements CraftingContainer {
    private final ItemStackHandler items;
    private final CraftingTerminalContainer eventHandler;

    public WrappedCraftingInventory(ItemStackHandler items, CraftingTerminalContainer eventHandlerIn) {
        this.eventHandler = eventHandlerIn;
        this.items = items;
    }

    public int getContainerSize() {
        return this.items.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            if (this.items.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return this.items.getStackInSlot(index);
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack before = this.items.getStackInSlot(index);
        this.items.setStackInSlot(index, ItemStack.EMPTY);
        return before;
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack ret;
        ItemStack slotStack = this.items.getStackInSlot(index);
        ItemStack itemStack = ret = !slotStack.isEmpty() && count > 0 ? slotStack.split(count) : ItemStack.EMPTY;
        if (!ret.isEmpty()) {
            this.eventHandler.slotsChanged((Container)this);
        }
        return ret;
    }

    public void setItem(int index, ItemStack stack) {
        this.items.setStackInSlot(index, stack);
        this.eventHandler.slotsChanged((Container)this);
    }

    public void setChanged() {
        this.eventHandler.slotsChanged((Container)this);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            this.items.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public void fillStackedContents(StackedContents helper) {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            helper.accountStack(this.items.getStackInSlot(i));
        }
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }

    public List<ItemStack> getItems() {
        return IntStream.range(0, this.getContainerSize()).mapToObj(this::getItem).toList();
    }
}

