/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.registry;

import com.google.gson.JsonParser;
import dev.obscuria.tooltips.ObscureTooltips;
import dev.obscuria.tooltips.client.registry.ResourceKind;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.apache.commons.lang3.StringUtils;

public final class TooltipManager
implements ResourceManagerReloadListener {
    public static final TooltipManager INSTANCE = new TooltipManager();

    private TooltipManager() {
    }

    public void onResourceManagerReload(ResourceManager manager) {
        for (ResourceKind kind : ResourceKind.values()) {
            kind.spec.onReloadStart();
            Map resources = manager.listResources(kind.spec.resourceDir(), this::isValidResource);
            resources.forEach((path, resource) -> this.loadResource(kind, (ResourceLocation)path, (Resource)resource));
            kind.spec.onReloadEnd();
        }
    }

    private boolean isValidResource(ResourceLocation path) {
        return path.toString().endsWith(".json");
    }

    private void loadResource(ResourceKind kind, ResourceLocation path, Resource resource) {
        try {
            kind.spec.load(this.extractKey(kind, path), JsonParser.parseReader((Reader)resource.openAsReader()));
        }
        catch (IOException exception) {
            ObscureTooltips.LOGGER.error("Failed to load resource {}: {}", (Object)path, (Object)exception.getMessage());
        }
    }

    private ResourceLocation extractKey(ResourceKind kind, ResourceLocation path) {
        return path.withPath(it -> {
            String result = StringUtils.removeStart((String)it, (String)(kind.spec.resourceDir() + "/"));
            result = StringUtils.removeEnd((String)result, (String)".json");
            return result;
        });
    }
}

