/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.element.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.fragmentum.content.util.color.ARGB;
import dev.obscuria.fragmentum.content.util.easing.Easing;
import dev.obscuria.fragmentum.content.util.easing.EasingFunction;
import dev.obscuria.tooltips.ObscureTooltips;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.tooltip.element.effect.TooltipEffect;
import dev.obscuria.tooltips.client.tooltip.particle.GraphicUtils;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public record RayGlowEffect(ARGB primaryColor, ARGB secondaryColor) implements TooltipEffect
{
    public static final ResourceLocation TEXTURE = ObscureTooltips.key("textures/gui/effect/ray_glow.png");
    public static final MapCodec<RayGlowEffect> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)ARGB.CODEC.fieldOf("primary_color").forGetter(RayGlowEffect::primaryColor), (App)ARGB.CODEC.fieldOf("secondary_color").forGetter(RayGlowEffect::secondaryColor)).apply((Applicative)codec, RayGlowEffect::new));

    public MapCodec<RayGlowEffect> codec() {
        return CODEC;
    }

    @Override
    public boolean canApply(List<TooltipEffect> effects) {
        return effects.stream().noneMatch(it -> it instanceof RayGlowEffect);
    }

    @Override
    public void renderIcon(TooltipState state, GuiGraphics graphics, int x, int y) {
        float time = state.timeInSeconds();
        float base = Mth.clamp((float)Easing.EASE_OUT_CUBIC.compute(time / 0.5f), (float)0.0f, (float)1.0f);
        float scale = base + 0.75f * Easing.EASE_OUT_CUBIC.mergeOut((EasingFunction)Easing.EASE_OUT_CUBIC, 0.25f).compute(time);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GraphicUtils.setShaderColor(this.primaryColor);
        this.renderSegment(graphics, x, y, 1.0f * scale, 0.5f, time);
        GraphicUtils.setShaderColor(this.primaryColor.lerp(this.secondaryColor, 0.5f));
        this.renderSegment(graphics, x, y, 0.75f * scale, -0.33f, time);
        GraphicUtils.setShaderColor(this.secondaryColor);
        this.renderSegment(graphics, x, y, 0.5f * scale, 0.25f, time);
        GraphicUtils.resetShaderColor();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    private void renderSegment(GuiGraphics graphics, int x, int y, float scale, float rotDelta, float timer) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)x, (float)y, 0.0f);
        graphics.pose().scale(scale, scale, scale);
        graphics.pose().mulPose(Axis.ZP.rotation(rotDelta * 3.0f + rotDelta * timer));
        graphics.blit(TEXTURE, -32, -32, 0.0f, 0.0f, 64, 64, 64, 64);
        graphics.pose().popPose();
    }
}

