/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.filter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.tooltips.client.tooltip.filter.ItemFilter;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public record EnchantmentFilter(Optional<Boolean> anyEnchantment, Optional<Boolean> anyCurse, Optional<List<ResourceLocation>> enchantments) implements ItemFilter
{
    public static final MapCodec<EnchantmentFilter> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)Codec.BOOL.optionalFieldOf("any_enchantment").forGetter(EnchantmentFilter::anyEnchantment), (App)Codec.BOOL.optionalFieldOf("any_curse").forGetter(EnchantmentFilter::anyCurse), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("enchantments").forGetter(EnchantmentFilter::enchantments)).apply((Applicative)codec, EnchantmentFilter::new));

    public MapCodec<EnchantmentFilter> codec() {
        return CODEC;
    }

    @Override
    public boolean test(ItemStack stack) {
        if (this.anyEnchantment.isPresent() && !this.anyEnchantment.get().equals(stack.isEnchanted())) {
            return false;
        }
        if (this.anyCurse.isPresent() && !this.anyCurse.get().equals(this.isCursed(stack))) {
            return false;
        }
        return !this.enchantments.isPresent() || this.containsAll(stack, this.enchantments.get());
    }

    private boolean isCursed(ItemStack stack) {
        return ((ItemEnchantments)stack.getComponents().getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).keySet().stream().anyMatch(it -> it.is(EnchantmentTags.CURSE));
    }

    private boolean containsAll(ItemStack stack, List<ResourceLocation> enchantmentIds) {
        ItemEnchantments enchantments = (ItemEnchantments)stack.getComponents().getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        return enchantmentIds.stream().allMatch(id -> enchantments.keySet().stream().anyMatch(it -> it.is(id)));
    }
}

