/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.filter;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.tooltips.client.tooltip.filter.ItemFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record NbtFilter(CompoundTag nbt, boolean matchExact) implements ItemFilter
{
    public static final MapCodec<NbtFilter> CODEC;

    public MapCodec<NbtFilter> codec() {
        return CODEC;
    }

    @Override
    public boolean test(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (Minecraft.getInstance().level == null) {
            return false;
        }
        RegistryAccess registryAccess = Minecraft.getInstance().level.registryAccess();
        CompoundTag savedItem = (CompoundTag)stack.save((HolderLookup.Provider)registryAccess);
        CompoundTag components = savedItem.getCompound("components");
        return this.matchExact ? NbtUtils.compareNbt((Tag)this.nbt, (Tag)components, (boolean)true) : NbtFilter.isSubtagOf((Tag)this.nbt, (Tag)components);
    }

    private static DataResult<CompoundTag> tryParseNbt(String input) {
        try {
            return DataResult.success((Object)TagParser.parseTag((String)input));
        }
        catch (CommandSyntaxException exception) {
            return DataResult.error(() -> "Invalid tag: " + exception.getMessage());
        }
    }

    private static boolean isSubtagOf(@Nullable Tag tag, @Nullable Tag parent) {
        if (tag == null) {
            return true;
        }
        if (parent == null) {
            return false;
        }
        if (tag.getId() != parent.getId()) {
            return false;
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compound1 = (CompoundTag)tag;
            if (parent instanceof CompoundTag) {
                CompoundTag compound2 = (CompoundTag)parent;
                for (String key : compound1.getAllKeys()) {
                    Tag sub2;
                    Tag sub1 = compound1.get(key);
                    if (NbtFilter.isSubtagOf(sub1, sub2 = compound2.get(key))) continue;
                    return false;
                }
                return true;
            }
        }
        if (tag instanceof ListTag) {
            ListTag list1 = (ListTag)tag;
            if (parent instanceof ListTag) {
                ListTag list2 = (ListTag)parent;
                if (list1.size() > list2.size()) {
                    return false;
                }
                for (Tag element1 : list1) {
                    boolean found = false;
                    for (Tag element2 : list2) {
                        if (!NbtFilter.isSubtagOf(element1, element2)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                return true;
            }
        }
        return tag.equals((Object)parent);
    }

    static {
        Codec tagCodec = Codec.STRING.comapFlatMap(NbtFilter::tryParseNbt, CompoundTag::toString);
        CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)tagCodec.fieldOf("nbt").forGetter(NbtFilter::nbt), (App)Codec.BOOL.optionalFieldOf("match_exact", (Object)false).forGetter(NbtFilter::matchExact)).apply((Applicative)codec, NbtFilter::new));
    }
}

