/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.packs;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackSource;

public interface BuiltInPackRegistry {
    public static final Multimap<String, Registration> CLIENT_REGISTRATIONS = HashMultimap.create();
    public static final Multimap<String, Registration> SERVER_REGISTRATIONS = HashMultimap.create();

    public static void registerResourcePack(Class<?> modClass, String modId, String directory, Component displayName, PackSelectionConfig config, PackSource source) {
        CLIENT_REGISTRATIONS.put((Object)modId, (Object)new Registration(modClass, directory, displayName, config, source));
    }

    public static void registerDataPack(Class<?> modClass, String modId, String directory, Component displayName, PackSelectionConfig config, PackSource source) {
        SERVER_REGISTRATIONS.put((Object)modId, (Object)new Registration(modClass, directory, displayName, config, source));
    }

    public static void forEachRegistration(PackType type, BiConsumer<String, Registration> consumer) {
        if (type == PackType.CLIENT_RESOURCES) {
            CLIENT_REGISTRATIONS.forEach(consumer);
        } else {
            SERVER_REGISTRATIONS.forEach(consumer);
        }
    }

    public record Registration(Class<?> modClass, String directory, Component displayName, PackSelectionConfig config, PackSource source) {
    }
}

