/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.packs;

import dev.obscuria.fragmentum.Fragmentum;
import dev.obscuria.fragmentum.content.packs.BuiltInPackRegistry;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.RepositorySource;
import org.jetbrains.annotations.Nullable;

public record BuiltInRepositorySource(PackType type) implements RepositorySource
{
    public void loadPacks(Consumer<Pack> consumer) {
        BuiltInPackRegistry.forEachRegistration(this.type, (modId, registration) -> {
            PathPackResources.PathResourcesSupplier resourceSupplier;
            Path rootPath = this.resolvePath((String)modId, (BuiltInPackRegistry.Registration)registration);
            if (rootPath == null) {
                return;
            }
            String packId = "%s/%s".formatted(modId, registration.directory());
            PackLocationInfo locationInfo = new PackLocationInfo(packId, registration.displayName(), registration.source(), Optional.empty());
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)locationInfo, (Pack.ResourcesSupplier)(resourceSupplier = new PathPackResources.PathResourcesSupplier(rootPath)), (PackType)this.type, (PackSelectionConfig)registration.config());
            if (pack != null) {
                consumer.accept(pack);
            }
        });
    }

    @Nullable
    private Path resolvePath(String modId, BuiltInPackRegistry.Registration registration) {
        return this.resolveRootPath(registration.modClass(), modId, registration.directory()).orElse(null);
    }

    public Optional<Path> resolveRootPath(Class<?> modClass, String modId, String directory) {
        try {
            URL resource = modClass.getResource("/" + directory);
            if (resource == null) {
                throw new FileNotFoundException("Resource not found: " + directory);
            }
            URI uri = resource.toURI();
            String scheme = uri.getScheme();
            if (scheme.equals("jar")) {
                FileSystem fileSystem = FileSystems.getFileSystem(uri);
                return Optional.of(fileSystem.getPath("/" + directory, new String[0]));
            }
            if (scheme.equals("file") || scheme.equals("union")) {
                return Optional.of(Paths.get(uri));
            }
            throw new IllegalStateException("Unsupported URI scheme: " + scheme);
        }
        catch (Exception exception) {
            Fragmentum.LOGGER.error("Failed to resolve `{}:{}`: {}", new Object[]{modId, directory, exception});
            return Optional.empty();
        }
    }
}

