/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.script.types;

import dev.obscuria.fragmentum.content.script.types.LuaLevel;
import dev.obscuria.fragmentum.content.script.types.LuaOps;
import dev.obscuria.fragmentum.content.script.types.LuaVec3;
import dev.obscuria.fragmentum.content.script.types.LuaWrapper;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaValue;

public class LuaEntity<T extends Entity>
extends LuaWrapper<T> {
    public static final LuaOps<Entity> OPS = LuaOps.nonnil(LuaEntity::valueOf, LuaEntity::nonnilSourceOf);
    public static final LuaOps.Nilable<Entity> NIL_OPS = LuaOps.nilable(LuaEntity::valueOf, LuaEntity::nilableSourceOf);

    public LuaEntity(T entity) {
        super(entity, LuaOps.nonnil(LuaEntity::valueOf, LuaEntity::nonnilSourceOf));
    }

    public LuaEntity(T entity, LuaOps<T> ops) {
        super(entity, ops);
    }

    @Override
    protected void build(LuaWrapper.Builder builder) {
        builder.put("tickCount", LuaWrapper.Property.of(LuaOps.INT, LuaEntity::getTickCount, LuaEntity::setTickCount));
        builder.put("position", LuaWrapper.Property.of(LuaVec3.OPS, Entity::position, Entity::setPos));
        builder.put("level", LuaWrapper.Property.readOnly(LuaLevel.OPS, Entity::level));
        builder.put("canSeeSky", this.method0(LuaOps.BOOL, LuaEntity::canSeeSky));
        builder.put("isInWaterOrRain", this.method0(LuaOps.BOOL, Entity::isInWaterOrRain));
        builder.put("isInWaterRainOrBubble", this.method0(LuaOps.BOOL, Entity::isInWaterRainOrBubble));
    }

    private static int getTickCount(Entity entity) {
        return entity.tickCount;
    }

    private static void setTickCount(Entity entity, int tickCount) {
        entity.tickCount = tickCount;
    }

    private static boolean canSeeSky(Entity entity) {
        return entity.level().canSeeSky(entity.blockPosition());
    }

    private static <T extends Entity> LuaValue valueOf(@Nullable T entity) {
        return entity == null ? LuaValue.NIL : new LuaEntity<T>(entity);
    }

    @Nullable
    private static <T extends Entity> T nilableSourceOf(LuaValue value) {
        return (T)(value.isnil() ? null : (Entity)((LuaEntity)value).getSource());
    }

    private static <T extends Entity> T nonnilSourceOf(LuaValue value) {
        return (T)((Entity)((LuaEntity)value).getSource());
    }
}

