/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.neoforge.registry;

import dev.obscuria.fragmentum.client.ClientRegistrar;
import dev.obscuria.fragmentum.content.registry.Deferred;
import dev.obscuria.fragmentum.content.registry.DeferredBlock;
import dev.obscuria.fragmentum.content.registry.DeferredBlockEntity;
import dev.obscuria.fragmentum.content.registry.DeferredEntity;
import dev.obscuria.fragmentum.content.registry.DeferredItem;
import dev.obscuria.fragmentum.content.registry.DeferredParticle;
import dev.obscuria.fragmentum.neoforge.NeoFragmentum;
import java.util.Arrays;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public record NeoClientRegistrar(String modId) implements ClientRegistrar
{
    @Override
    public <T extends Entity> void registerEntityRenderer(DeferredEntity<T> entity, EntityRendererProvider<T> provider) {
        NeoFragmentum.addListener(this.modId, event -> event.registerEntityRenderer((EntityType)entity.get(), provider));
    }

    @Override
    public <T extends BlockEntity> void registerBlockEntityRenderer(DeferredBlockEntity<T> entity, BlockEntityRendererProvider<T> provider) {
        NeoFragmentum.addListener(this.modId, event -> event.registerBlockEntityRenderer((BlockEntityType)entity.get(), provider));
    }

    @Override
    public <T extends ParticleOptions> void registerParticleRenderer(DeferredParticle<T> particle, ParticleProvider<T> provider) {
        NeoFragmentum.addListener(this.modId, event -> event.registerSpecial((ParticleType)particle.get(), provider));
    }

    @Override
    public <T extends ParticleOptions> void registerTexturedParticleRenderer(DeferredParticle<T> particle, ClientRegistrar.TexturedParticleProvider<T> provider) {
        NeoFragmentum.addListener(this.modId, event -> event.registerSpriteSet((ParticleType)particle.get(), provider::create));
    }

    @Override
    public void registerModelLayer(ModelLayerLocation location, ClientRegistrar.ModelLayerProvider provider) {
        NeoFragmentum.addListener(this.modId, event -> event.registerLayerDefinition(location, provider::create));
    }

    @Override
    public void registerItemColor(ClientRegistrar.ItemColorProvider provider, DeferredItem<?> ... items) {
        NeoFragmentum.addListener(this.modId, event -> event.register(provider::pick, (ItemLike[])Arrays.stream(items).map(Deferred::get).toArray(Item[]::new)));
    }

    @Override
    public void registerBlockColor(ClientRegistrar.BlockColorProvider provider, DeferredBlock<?> ... blocks) {
        NeoFragmentum.addListener(this.modId, event -> event.register(provider::pick, (Block[])Arrays.stream(blocks).map(Deferred::get).toArray(Block[]::new)));
    }

    @Override
    public void registerItemProperty(ResourceLocation key, ClampedItemPropertyFunction function) {
        ItemProperties.registerGeneric((ResourceLocation)key, (ItemPropertyFunction)function);
    }
}

