/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.neoforge.service;

import dev.obscuria.fragmentum.Fragmentum;
import dev.obscuria.fragmentum.config.ConfigBuilder;
import dev.obscuria.fragmentum.service.ConfigService;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class NeoConfigService
implements ConfigService {
    public static final NeoConfigService INSTANCE = new NeoConfigService();

    private NeoConfigService() {
    }

    @Override
    public void registerClient(String modId, ConfigBuilder builder) {
        this.registerInternal(modId, builder, ModConfig.Type.CLIENT);
    }

    @Override
    public void registerCommon(String modId, ConfigBuilder builder) {
        this.registerInternal(modId, builder, ModConfig.Type.COMMON);
    }

    @Override
    public void registerServer(String modId, ConfigBuilder builder) {
        this.registerInternal(modId, builder, ModConfig.Type.SERVER);
    }

    private void registerInternal(String modId, ConfigBuilder builder, ModConfig.Type type) {
        ModConfigSpec spec = builder.specBuilder.build();
        ModContainer container = ModLoadingContext.get().getActiveContainer();
        if (builder.fileName == null) {
            container.registerConfig(type, (IConfigSpec)spec);
        } else {
            container.registerConfig(type, (IConfigSpec)spec, builder.fileName);
        }
        if (Fragmentum.PLATFORM.isDedicatedServer()) {
            return;
        }
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }
}

