/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.obscuria.fragmentum.content.util.color.ARGB;
import dev.obscuria.fragmentum.content.util.color.Colors;
import dev.obscuria.tooltips.client.tooltip.element.QuadPalette;
import net.minecraft.class_1921;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import org.joml.Matrix4f;

public interface GraphicUtils {
    public static final ARGB WHITE = Colors.argbOf((int)-1);

    public static void setShaderColor(ARGB color) {
        RenderSystem.setShaderColor((float)color.red(), (float)color.green(), (float)color.blue(), (float)color.alpha());
    }

    public static void resetShaderColor() {
        GraphicUtils.setShaderColor(WHITE);
    }

    public static void drawFrame(class_332 graphics, int x, int y, int width, int height, QuadPalette palette) {
        GraphicUtils.drawFrame(graphics, x, y, width, height, palette.topLeft(), palette.topRight(), palette.bottomLeft(), palette.bottomRight());
    }

    public static void drawFrame(class_332 graphics, int x, int y, int width, int height, ARGB topLeft, ARGB topRight, ARGB bottomLeft, ARGB bottomRight) {
        GraphicUtils.drawHLine(graphics, x, y, width, topLeft, topRight);
        GraphicUtils.drawHLine(graphics, x, y + height - 1, width, bottomLeft, bottomRight);
        GraphicUtils.drawVLine(graphics, x, y + 1, height - 2, topLeft, bottomLeft);
        GraphicUtils.drawVLine(graphics, x + width - 1, y + 1, height - 2, topRight, bottomRight);
    }

    public static void drawHLine(class_332 graphics, int x, int y, int length, ARGB start, ARGB end) {
        GraphicUtils.drawRect(graphics, class_1921.method_51784(), x, y, length, 1, start, end, start, end);
    }

    public static void drawVLine(class_332 graphics, int x, int y, int length, ARGB start, ARGB end) {
        GraphicUtils.drawRect(graphics, class_1921.method_51784(), x, y, 1, length, start, start, end, end);
    }

    public static void drawHLineOverlay(class_332 graphics, int x, int y, int length, ARGB start, ARGB end) {
        GraphicUtils.drawRect(graphics, class_1921.method_51785(), x, y, length, 1, start, end, start, end);
    }

    public static void drawVLineOverlay(class_332 graphics, int x, int y, int length, ARGB start, ARGB end) {
        GraphicUtils.drawRect(graphics, class_1921.method_51785(), x, y, 1, length, start, start, end, end);
    }

    public static void drawRect(class_332 graphics, int x, int y, int width, int height, QuadPalette palette) {
        GraphicUtils.drawRect(graphics, class_1921.method_51784(), x, y, width, height, palette.topLeft(), palette.topRight(), palette.bottomLeft(), palette.bottomRight());
    }

    public static void drawRect(class_332 graphics, class_1921 type, int x, int y, int width, int height, ARGB topLeft, ARGB topRight, ARGB bottomLeft, ARGB bottomRight) {
        class_4588 consumer = graphics.method_51450().getBuffer(type);
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        float minX = x;
        float minY = y;
        float maxX = x + width;
        float maxY = y + height;
        GraphicUtils.color(consumer.method_22918(matrix, minX, minY, 0.0f), topLeft);
        GraphicUtils.color(consumer.method_22918(matrix, minX, maxY, 0.0f), bottomLeft);
        GraphicUtils.color(consumer.method_22918(matrix, maxX, maxY, 0.0f), bottomRight);
        GraphicUtils.color(consumer.method_22918(matrix, maxX, minY, 0.0f), topRight);
    }

    public static class_4588 color(class_4588 consumer, ARGB color) {
        return consumer.method_22915(color.red(), color.green(), color.blue(), color.alpha());
    }
}

