/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.packs;

import dev.obscuria.fragmentum.Fragmentum;
import dev.obscuria.fragmentum.content.packs.BuiltInPackRegistry;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.jetbrains.annotations.Nullable;

public record BuiltInRepositorySource(class_3264 type) implements class_3285
{
    public void method_14453(Consumer<class_3288> consumer) {
        BuiltInPackRegistry.forEachRegistration(this.type, (modId, registration) -> {
            class_3259.class_8619 resourceSupplier;
            Path rootPath = this.resolvePath((String)modId, (BuiltInPackRegistry.Registration)registration);
            if (rootPath == null) {
                return;
            }
            String packId = "%s/%s".formatted(modId, registration.directory());
            class_9224 locationInfo = new class_9224(packId, registration.displayName(), registration.source(), Optional.empty());
            class_3288 pack = class_3288.method_45275((class_9224)locationInfo, (class_3288.class_7680)(resourceSupplier = new class_3259.class_8619(rootPath)), (class_3264)this.type, (class_9225)registration.config());
            if (pack != null) {
                consumer.accept(pack);
            }
        });
    }

    @Nullable
    private Path resolvePath(String modId, BuiltInPackRegistry.Registration registration) {
        return this.resolveRootPath(registration.modClass(), modId, registration.directory()).orElse(null);
    }

    public Optional<Path> resolveRootPath(Class<?> modClass, String modId, String directory) {
        try {
            URL resource = modClass.getResource("/" + directory);
            if (resource == null) {
                throw new FileNotFoundException("Resource not found: " + directory);
            }
            URI uri = resource.toURI();
            String scheme = uri.getScheme();
            if (scheme.equals("jar")) {
                FileSystem fileSystem = FileSystems.getFileSystem(uri);
                return Optional.of(fileSystem.getPath("/" + directory, new String[0]));
            }
            if (scheme.equals("file") || scheme.equals("union")) {
                return Optional.of(Paths.get(uri));
            }
            throw new IllegalStateException("Unsupported URI scheme: " + scheme);
        }
        catch (Exception exception) {
            Fragmentum.LOGGER.error("Failed to resolve `{}:{}`: {}", new Object[]{modId, directory, exception});
            return Optional.empty();
        }
    }
}

