/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.packs;

import dev.obscuria.fragmentum.Fragmentum;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3281;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7699;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.jetbrains.annotations.Nullable;

public final class FragmentumLayer {

    public record ResourcesSupplier(Path root) implements class_3288.class_7680
    {
        public class_3262 method_52424(class_9224 info) {
            return new Resources(info, this.root);
        }

        public class_3262 method_52425(class_9224 info, class_3288.class_7679 metadata) {
            return new Resources(info, this.root);
        }
    }

    public static final class Resources
    extends class_3259 {
        public Resources(class_9224 info, Path root) {
            super(info, root);
        }

        @Nullable
        public class_7367<InputStream> method_14410(String ... path) {
            String fileName = String.join((CharSequence)"/", path);
            if (!fileName.equals("pack.png")) {
                return super.method_14410(path);
            }
            return this::getDefaultIcon;
        }

        private InputStream getDefaultIcon() {
            try {
                InputStream resource = Fragmentum.class.getResourceAsStream("/fragmentum.png");
                if (resource == null) {
                    throw new IllegalStateException("Resource `fragmentum.png` not found");
                }
                return resource;
            }
            catch (Exception exception) {
                Fragmentum.LOGGER.error("Failed to load Fragmentum icon", (Throwable)exception);
                return InputStream.nullInputStream();
            }
        }
    }

    public record Source(Path directory, class_3264 type) implements class_3285
    {
        public static final class_9224 INFO;
        public static final class_3288.class_7679 CLIENT_METADATA;
        public static final class_3288.class_7679 SERVER_METADATA;
        public static final class_9225 CONFIG;

        public static Source create(class_3264 type) {
            Path userDir = Path.of(System.getProperty("user.dir"), new String[0]).toAbsolutePath().normalize();
            return new Source(userDir.resolve("config/fragmentum"), type);
        }

        public void method_14453(Consumer<class_3288> consumer) {
            class_3288.class_7679 metadata = this.type == class_3264.field_14188 ? CLIENT_METADATA : SERVER_METADATA;
            ResourcesSupplier resourceSupplier = new ResourcesSupplier(this.directory);
            consumer.accept(new class_3288(INFO, (class_3288.class_7680)resourceSupplier, metadata, CONFIG));
        }

        static {
            CONFIG = new class_9225(true, class_3288.class_3289.field_14280, false);
            INFO = new class_9224("generated/fragmentum_layer", (class_2561)class_2561.method_43470((String)"Fragmentum Layer"), class_5352.field_25348, Optional.empty());
            CLIENT_METADATA = new class_3288.class_7679((class_2561)class_2561.method_43470((String)"Global resources"), class_3281.field_14224, class_7699.method_45397(), List.of());
            SERVER_METADATA = new class_3288.class_7679((class_2561)class_2561.method_43470((String)"Global configurations"), class_3281.field_14224, class_7699.method_45397(), List.of());
        }
    }
}

