/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.util.color;

import com.mojang.serialization.Codec;
import dev.obscuria.fragmentum.content.util.color.Colors;
import dev.obscuria.fragmentum.content.util.color.HSV;
import dev.obscuria.fragmentum.content.util.color.RGB;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_3532;

public record ARGB(float alpha, float red, float green, float blue) {
    public static final Codec<ARGB> DECIMAL_CODEC = Codec.INT.xmap(Colors::argbOf, ARGB::decimal);
    public static final Codec<ARGB> HEXADECIMAL_CODEC = Codec.STRING.xmap(Colors::argbOf, ARGB::hexadecimal);
    public static final Codec<ARGB> NORMALIZED_CODEC = Codec.FLOAT.listOf().xmap(Colors::argbOf, ARGB::normalized);
    public static final Codec<ARGB> CODEC = Codec.withAlternative(DECIMAL_CODEC, (Codec)Codec.withAlternative(HEXADECIMAL_CODEC, NORMALIZED_CODEC));

    public int decimal() {
        int a = Math.min(255, Math.max(0, (int)(this.alpha * 255.0f)));
        int r = Math.min(255, Math.max(0, (int)(this.red * 255.0f)));
        int g = Math.min(255, Math.max(0, (int)(this.green * 255.0f)));
        int b = Math.min(255, Math.max(0, (int)(this.blue * 255.0f)));
        return a << 24 | r << 16 | g << 8 | b;
    }

    public String hexadecimal() {
        return String.format("#%08X", this.decimal());
    }

    public List<Float> normalized() {
        return List.of(Float.valueOf(this.alpha), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public ARGB lerp(ARGB to, float delta) {
        return new ARGB(class_3532.method_16439((float)delta, (float)this.alpha, (float)to.alpha), class_3532.method_16439((float)delta, (float)this.red, (float)to.red), class_3532.method_16439((float)delta, (float)this.green, (float)to.green), class_3532.method_16439((float)delta, (float)this.blue, (float)to.blue));
    }

    public RGB toRGB() {
        return new RGB(this.red, this.green, this.blue);
    }

    public HSV toHSV() {
        return this.toRGB().toHSV();
    }

    @Generated
    public ARGB withAlpha(float alpha) {
        return this.alpha == alpha ? this : new ARGB(alpha, this.red, this.green, this.blue);
    }

    @Generated
    public ARGB withRed(float red) {
        return this.red == red ? this : new ARGB(this.alpha, red, this.green, this.blue);
    }

    @Generated
    public ARGB withGreen(float green) {
        return this.green == green ? this : new ARGB(this.alpha, this.red, green, this.blue);
    }

    @Generated
    public ARGB withBlue(float blue) {
        return this.blue == blue ? this : new ARGB(this.alpha, this.red, this.green, blue);
    }
}

