/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.util.color;

import dev.obscuria.fragmentum.content.util.color.ARGB;
import dev.obscuria.fragmentum.content.util.color.HSV;
import dev.obscuria.fragmentum.content.util.color.RGB;
import java.util.List;

public interface Colors {
    public static ARGB argbOf(float alpha, float red, float green, float blue) {
        return new ARGB(alpha, red, green, blue);
    }

    public static ARGB argbOf(int decimal) {
        return new ARGB((float)(decimal >> 24 & 0xFF) / 255.0f, (float)(decimal >> 16 & 0xFF) / 255.0f, (float)(decimal >> 8 & 0xFF) / 255.0f, (float)(decimal & 0xFF) / 255.0f);
    }

    public static ARGB argbOf(String hexadecimal) {
        String hex = hexadecimal.replace("#", "");
        return Colors.argbOf((int)Long.parseLong(hex, 16));
    }

    public static ARGB argbOf(List<Float> normalized) {
        if (normalized.size() != 4) {
            throw new IllegalArgumentException();
        }
        return Colors.argbOf(normalized.get(0).floatValue(), normalized.get(1).floatValue(), normalized.get(2).floatValue(), normalized.get(3).floatValue());
    }

    public static RGB rgbOf(float red, float green, float blue) {
        return new RGB(red, green, blue);
    }

    public static RGB rgbOf(int decimal) {
        return new RGB((float)(decimal >> 16 & 0xFF) / 255.0f, (float)(decimal >> 8 & 0xFF) / 255.0f, (float)(decimal & 0xFF) / 255.0f);
    }

    public static RGB rgbOf(String hexadecimal) {
        String hex = hexadecimal.replace("#", "");
        return Colors.rgbOf(Integer.parseInt(hex, 16) | 0xFF000000);
    }

    public static RGB rgbOf(List<Float> normalized) {
        if (normalized.size() != 3) {
            throw new IllegalArgumentException();
        }
        return Colors.rgbOf(normalized.get(0).floatValue(), normalized.get(1).floatValue(), normalized.get(2).floatValue());
    }

    public static HSV hsvOf(float hue, float saturation, float value) {
        return new HSV(hue, saturation, value);
    }

    public static HSV hsvOf(List<Float> normalized) {
        if (normalized.size() != 3) {
            throw new IllegalArgumentException();
        }
        return Colors.hsvOf(normalized.get(0).floatValue(), normalized.get(1).floatValue(), normalized.get(2).floatValue());
    }
}

