/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.world.tooltip;

import dev.obscuria.fragmentum.content.util.color.RGB;
import dev.obscuria.fragmentum.content.world.tooltip.StyleFlag;
import dev.obscuria.fragmentum.content.world.tooltip.TooltipOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public class TooltipBuilder {
    private final TooltipOptions options;
    private final List<class_2561> lines = new ArrayList<class_2561>();
    private final List<RGB> colors = new ArrayList<RGB>();
    private final EnumSet<StyleFlag> flags = EnumSet.noneOf(StyleFlag.class);
    private class_5250 line = class_2561.method_43473();
    private int lineLength = 0;
    private boolean isLineEmpty = true;

    public TooltipBuilder(TooltipOptions options) {
        this.options = options;
    }

    public void pushColor(RGB color) {
        this.colors.add(color);
    }

    public void popColor() {
        if (!this.colors.isEmpty()) {
            this.colors.remove(this.colors.size() - 1);
        }
    }

    public void pushFlag(StyleFlag flag) {
        this.flags.add(flag);
    }

    public void popFlag(StyleFlag flag) {
        this.flags.remove((Object)flag);
    }

    public void breakLine() {
        this.flush();
    }

    public void prepareForAppend(int length) {
        if (this.lineLength + length + 1 > this.options.maxLineLength()) {
            this.flush();
        }
    }

    public void maybeAppendSpacing() {
        if (!this.isLineEmpty) {
            this.line.method_10852(class_5244.field_41874);
            ++this.lineLength;
        }
    }

    public void append(int length, class_5250 component) {
        this.line.method_10852((class_2561)this.applyStyle(component));
        this.lineLength += length;
        this.isLineEmpty = false;
    }

    public List<class_2561> result() {
        if (!this.isLineEmpty) {
            this.flush();
        }
        return Collections.unmodifiableList(this.lines);
    }

    private class_5250 applyStyle(class_5250 component) {
        for (RGB color : this.colors) {
            component.method_27696(component.method_10866().method_36139(color.decimal()));
        }
        if (this.flags.contains((Object)StyleFlag.ITALIC)) {
            component.method_27696(component.method_10866().method_10978(Boolean.valueOf(true)));
        }
        if (this.flags.contains((Object)StyleFlag.NON_ITALIC)) {
            component.method_27696(component.method_10866().method_10978(Boolean.valueOf(false)));
        }
        if (this.flags.contains((Object)StyleFlag.BOLD)) {
            component.method_27696(component.method_10866().method_10982(Boolean.valueOf(true)));
        }
        if (this.flags.contains((Object)StyleFlag.NON_BOLD)) {
            component.method_27696(component.method_10866().method_10982(Boolean.valueOf(false)));
        }
        return component;
    }

    private void flush() {
        this.lines.add((class_2561)this.line.method_27696(this.options.getLineStyle(this.lines.size())));
        this.line = class_2561.method_43473();
        this.isLineEmpty = true;
        this.lineLength = 0;
    }
}

