/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.element.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.fragmentum.util.easing.Easing;
import dev.obscuria.fragmentum.util.easing.EasingFunction;
import dev.obscuria.tooltips.client.ParticleData;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.tooltip.element.effect.TooltipEffect;
import dev.obscuria.tooltips.client.tooltip.particle.TooltipParticle;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.RandomUtils;

public record IconParticleEffect(TooltipParticle particle) implements TooltipEffect
{
    public static final Codec<IconParticleEffect> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)TooltipParticle.CODEC.fieldOf("particle").forGetter(IconParticleEffect::particle)).apply((Applicative)codec, IconParticleEffect::new));

    public Codec<IconParticleEffect> codec() {
        return CODEC;
    }

    @Override
    public boolean canApply(List<TooltipEffect> effects) {
        return effects.stream().noneMatch(it -> it instanceof IconParticleEffect);
    }

    @Override
    public void renderIcon(TooltipState state, GuiGraphics graphics, int x, int y) {
        float lastParticleTime = 0.0f;
        for (ParticleData particle : state.particles) {
            if (!particle.source.equals(this)) continue;
            particle.render(graphics, state, this.particle, x, y);
            lastParticleTime = Math.max(lastParticleTime, particle.startTime);
        }
        if (state.timeInSeconds() - lastParticleTime < 0.15f) {
            return;
        }
        Vec2 origin = Vec2.f_82462_;
        float direction = RandomUtils.nextFloat((float)0.0f, (float)((float)Math.PI * 2));
        Vec2 destination = new Vec2(12.0f * (float)Math.sin(direction), 12.0f * (float)Math.cos(direction));
        state.addParticle(new IconParticle(this, state.timeInSeconds(), origin, destination));
    }

    private static final class IconParticle
    extends ParticleData {
        public IconParticle(Object source, float startTime, Vec2 origin, Vec2 destination) {
            super(source, startTime, origin, destination);
        }

        @Override
        public float computeProgress(TooltipState state) {
            return Easing.EASE_OUT_CUBIC.compute(super.computeProgress(state) * 0.5f);
        }

        @Override
        public float computeScale(TooltipState state, float progress) {
            return Easing.EASE_OUT_CUBIC.mergeOut((EasingFunction)Easing.EASE_IN_CUBIC, 0.2f).compute(progress * 1.2f);
        }

        @Override
        public float computeRotation(TooltipState state, float progress) {
            return progress * 2.0f;
        }

        @Override
        public float lifetime() {
            return super.lifetime() * 2.0f;
        }
    }
}

