/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.filter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.tooltips.client.tooltip.filter.ItemFilter;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;

public record IdentifierFilter(TargetType target, Optional<String> contains, Optional<String> startsWith, Optional<String> endsWith) implements ItemFilter
{
    public static final Codec<IdentifierFilter> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)TargetType.CODEC.optionalFieldOf("target", (Object)TargetType.PATH).forGetter(IdentifierFilter::target), (App)Codec.STRING.optionalFieldOf("contains").forGetter(IdentifierFilter::contains), (App)Codec.STRING.optionalFieldOf("starts_with").forGetter(IdentifierFilter::startsWith), (App)Codec.STRING.optionalFieldOf("ends_with").forGetter(IdentifierFilter::endsWith)).apply((Applicative)codec, IdentifierFilter::new));

    public Codec<IdentifierFilter> codec() {
        return CODEC;
    }

    @Override
    public boolean test(ItemStack stack) {
        String value = this.target.resolve(stack.m_41720_().m_204114_().m_205785_().m_135782_());
        if (this.contains.isPresent() && !value.contains(this.contains.get())) {
            return false;
        }
        if (this.startsWith.isPresent() && !value.startsWith(this.startsWith.get())) {
            return false;
        }
        return !this.endsWith.isPresent() || value.endsWith(this.endsWith.get());
    }

    public static enum TargetType implements StringRepresentable
    {
        PATH(ResourceLocation::m_135815_),
        NAMESPACE(ResourceLocation::m_135827_),
        FULL(ResourceLocation::toString);

        public static final Codec<TargetType> CODEC;
        private final Function<ResourceLocation, String> extractor;

        private TargetType(Function<ResourceLocation, String> extractor) {
            this.extractor = extractor;
        }

        public String resolve(ResourceLocation identifier) {
            return this.extractor.apply(identifier);
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.m_216439_(TargetType::values);
        }
    }
}

