/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.forge.registry;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import dev.obscuria.fragmentum.registry.DelegatedRegistry;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public final class ForgeDelegatedRegistry<T>
implements DelegatedRegistry<T> {
    private final ResourceKey<? extends Registry<T>> key;
    private final Codec<Holder<T>> holderByNameCodec = this.createHolderByNameCodec();
    private final Mutable<IForgeRegistry<T>> source = new MutableObject();

    public ForgeDelegatedRegistry(ResourceKey<? extends Registry<T>> key) {
        this.key = key;
    }

    public void bind(IForgeRegistry<T> registry) {
        this.source.setValue(registry);
    }

    @Override
    public ResourceKey<? extends Registry<T>> key() {
        return this.key;
    }

    @Override
    public ResourceLocation name() {
        return this.key().m_211136_();
    }

    @Override
    public Codec<T> byNameCodec() {
        return Codec.of((Encoder)new Encoder<T>(){

            public <R> DataResult<R> encode(T input, DynamicOps<R> ops, R prefix) {
                return ((IForgeRegistry)ForgeDelegatedRegistry.this.source.getValue()).getCodec().encode(input, ops, prefix);
            }
        }, (Decoder)new Decoder<T>(){

            public <R> DataResult<Pair<T, R>> decode(DynamicOps<R> ops, R input) {
                return ((IForgeRegistry)ForgeDelegatedRegistry.this.source.getValue()).getCodec().decode(ops, input);
            }
        });
    }

    @Override
    public Codec<Holder<T>> holderByNameCodec() {
        return this.holderByNameCodec;
    }

    @Override
    public Set<ResourceLocation> keySet() {
        return ((IForgeRegistry)this.source.getValue()).getKeys();
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return ((IForgeRegistry)this.source.getValue()).getEntries();
    }

    @Override
    public boolean containsKey(ResourceLocation id) {
        return ((IForgeRegistry)this.source.getValue()).containsKey(id);
    }

    @Override
    public T get(ResourceLocation id) {
        return (T)((IForgeRegistry)this.source.getValue()).getValue(id);
    }

    @Override
    public Holder.Reference<T> getHolder(ResourceLocation id) {
        return ((IForgeRegistry)this.source.getValue()).getDelegate(id).orElse(null);
    }

    @Override
    public ResourceLocation getKey(T value) {
        return ((IForgeRegistry)this.source.getValue()).getKey(value);
    }

    @Override
    public ResourceLocation getKey(Holder<T> holder) {
        return holder.m_203439_().right().map(this::getKey).orElse(null);
    }

    private Codec<Holder<T>> createHolderByNameCodec() {
        return this.referenceHolderWithLifecycle().flatComapMap(reference -> reference, this::safeCastToReference);
    }

    private Codec<Holder.Reference<T>> referenceHolderWithLifecycle() {
        return ResourceLocation.f_135803_.comapFlatMap(id -> Optional.ofNullable(this.getHolder((ResourceLocation)id)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + this.key() + ": " + id)), reference -> reference.m_205785_().m_135782_());
    }

    private DataResult<Holder.Reference<T>> safeCastToReference(Holder<T> value) {
        DataResult dataResult;
        if (value instanceof Holder.Reference) {
            Holder.Reference reference = (Holder.Reference)value;
            dataResult = DataResult.success((Object)reference);
        } else {
            dataResult = DataResult.error(() -> "Unregistered holder in " + this.key() + ": " + value);
        }
        return dataResult;
    }
}

