/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.filter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.tooltips.client.tooltip.filter.ItemFilter;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3542;

public record IdentifierFilter(TargetType target, Optional<String> contains, Optional<String> startsWith, Optional<String> endsWith) implements ItemFilter
{
    public static final Codec<IdentifierFilter> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)TargetType.CODEC.optionalFieldOf("target", (Object)TargetType.PATH).forGetter(IdentifierFilter::target), (App)Codec.STRING.optionalFieldOf("contains").forGetter(IdentifierFilter::contains), (App)Codec.STRING.optionalFieldOf("starts_with").forGetter(IdentifierFilter::startsWith), (App)Codec.STRING.optionalFieldOf("ends_with").forGetter(IdentifierFilter::endsWith)).apply((Applicative)codec, IdentifierFilter::new));

    public Codec<IdentifierFilter> codec() {
        return CODEC;
    }

    @Override
    public boolean test(class_1799 stack) {
        String value = this.target.resolve(stack.method_7909().method_40131().method_40237().method_29177());
        if (this.contains.isPresent() && !value.contains(this.contains.get())) {
            return false;
        }
        if (this.startsWith.isPresent() && !value.startsWith(this.startsWith.get())) {
            return false;
        }
        return !this.endsWith.isPresent() || value.endsWith(this.endsWith.get());
    }

    public static enum TargetType implements class_3542
    {
        PATH(class_2960::method_12832),
        NAMESPACE(class_2960::method_12836),
        FULL(class_2960::toString);

        public static final Codec<TargetType> CODEC;
        private final Function<class_2960, String> extractor;

        private TargetType(Function<class_2960, String> extractor) {
            this.extractor = extractor;
        }

        public String resolve(class_2960 identifier) {
            return this.extractor.apply(identifier);
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(TargetType::values);
        }
    }
}

