/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.packs;

import dev.obscuria.fragmentum.Fragmentum;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7699;
import org.jetbrains.annotations.Nullable;

public final class FragmentumLayer {

    public static final class Resources
    extends class_3259 {
        private static final class_2960 ICON = Fragmentum.key("fragmentum_layer.png");

        public Resources(String packId, Path root) {
            super(packId, root, true);
        }

        @Nullable
        public class_7367<InputStream> method_14410(String ... path) {
            String fileName = String.join((CharSequence)"/", path);
            if (!fileName.equals("pack.png")) {
                return super.method_14410(path);
            }
            class_3300 manager = class_310.method_1551().method_1478();
            Optional resource = manager.method_14486(ICON);
            if (resource.isEmpty()) {
                return null;
            }
            return () -> ((class_3298)((class_3298)resource.orElseThrow())).method_14482();
        }
    }

    public record Source(Path directory, class_3264 type) implements class_3285
    {
        public static final class_3288.class_7679 CLIENT_METADATA;
        public static final class_3288.class_7679 SERVER_METADATA;

        public static Source create(class_3264 type) {
            Path root = Path.of(System.getProperty("user.dir"), new String[0]).toAbsolutePath().normalize();
            Path directory = root.resolve("config/fragmentum");
            Source.createDirectories(directory);
            return new Source(directory, type);
        }

        public void method_14453(Consumer<class_3288> consumer) {
            class_3288.class_7679 metadata = this.type == class_3264.field_14188 ? CLIENT_METADATA : SERVER_METADATA;
            consumer.accept(class_3288.method_14456((String)"generated/fragmentum_layer", (class_2561)class_2561.method_43470((String)"Fragmentum Layer"), (boolean)true, packId -> new Resources(packId, this.directory), (class_3288.class_7679)metadata, (class_3264)this.type, (class_3288.class_3289)class_3288.class_3289.field_14280, (boolean)false, (class_5352)class_5352.field_25348));
        }

        private static void createDirectories(Path directory) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (IOException exception) {
                Fragmentum.LOGGER.error("Failed to create directories: {}", (Object)directory, (Object)exception);
            }
        }

        static {
            int clientVersion = class_155.method_16673().method_48017(class_3264.field_14188);
            int serverVersion = class_155.method_16673().method_48017(class_3264.field_14190);
            CLIENT_METADATA = new class_3288.class_7679((class_2561)class_2561.method_43470((String)"Global resources"), clientVersion, class_7699.method_45397());
            SERVER_METADATA = new class_3288.class_7679((class_2561)class_2561.method_43470((String)"Global configurations"), serverVersion, class_7699.method_45397());
        }
    }
}

