/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsspiders.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.nyfaria.nyfsspiders.common.entity.mob.IClimberEntity;
import com.nyfaria.nyfsspiders.common.entity.mob.Orientation;
import com.nyfaria.nyfsspiders.common.entity.mob.PathingTarget;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class ClientEventHandlers {
    public static void onPreRenderLiving(LivingEntity entity, float partialTicks, PoseStack matrixStack) {
        if (entity instanceof IClimberEntity) {
            IClimberEntity climber = (IClimberEntity)entity;
            Orientation orientation = climber.getOrientation();
            Orientation renderOrientation = climber.calculateOrientation(partialTicks);
            climber.setRenderOrientation(renderOrientation);
            float verticalOffset = climber.getVerticalOffset(partialTicks);
            float x = climber.getAttachmentOffset(Direction.Axis.X, partialTicks) - (float)renderOrientation.normal.x * verticalOffset;
            float y = climber.getAttachmentOffset(Direction.Axis.Y, partialTicks) - (float)renderOrientation.normal.y * verticalOffset;
            float z = climber.getAttachmentOffset(Direction.Axis.Z, partialTicks) - (float)renderOrientation.normal.z * verticalOffset;
            matrixStack.translate(x, y, z);
            matrixStack.mulPose(Axis.YP.rotationDegrees(renderOrientation.yaw));
            matrixStack.mulPose(Axis.XP.rotationDegrees(renderOrientation.pitch));
            matrixStack.mulPose(Axis.YP.rotationDegrees(Math.signum(0.5f - orientation.componentY - orientation.componentZ - orientation.componentX) * renderOrientation.yaw));
        }
    }

    public static void onPostRenderLiving(LivingEntity entity, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn) {
        if (entity instanceof IClimberEntity) {
            IClimberEntity climber = (IClimberEntity)entity;
            Orientation orientation = climber.getOrientation();
            Orientation renderOrientation = climber.getRenderOrientation();
            if (renderOrientation != null) {
                float verticalOffset = climber.getVerticalOffset(partialTicks);
                float x = climber.getAttachmentOffset(Direction.Axis.X, partialTicks) - (float)renderOrientation.normal.x * verticalOffset;
                float y = climber.getAttachmentOffset(Direction.Axis.Y, partialTicks) - (float)renderOrientation.normal.y * verticalOffset;
                float z = climber.getAttachmentOffset(Direction.Axis.Z, partialTicks) - (float)renderOrientation.normal.z * verticalOffset;
                matrixStack.mulPose(Axis.YP.rotationDegrees(-Math.signum(0.5f - orientation.componentY - orientation.componentZ - orientation.componentX) * renderOrientation.yaw));
                matrixStack.mulPose(Axis.XP.rotationDegrees(-renderOrientation.pitch));
                matrixStack.mulPose(Axis.YP.rotationDegrees(-renderOrientation.yaw));
                if (Minecraft.getInstance().getEntityRenderDispatcher().shouldRenderHitBoxes()) {
                    List<PathingTarget> pathingTargets;
                    LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)bufferIn.getBuffer((RenderType)RenderType.LINES), (AABB)new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).inflate((double)0.2f), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    double rx = entity.xo + (entity.getX() - entity.xo) * (double)partialTicks;
                    double ry = entity.yo + (entity.getY() - entity.yo) * (double)partialTicks;
                    double rz = entity.zo + (entity.getZ() - entity.zo) * (double)partialTicks;
                    Vec3 movementTarget = climber.getTrackedMovementTarget();
                    if (movementTarget != null) {
                        LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)bufferIn.getBuffer((RenderType)RenderType.LINES), (AABB)new AABB(movementTarget.x() - 0.25, movementTarget.y() - 0.25, movementTarget.z() - 0.25, movementTarget.x() + 0.25, movementTarget.y() + 0.25, movementTarget.z() + 0.25).move(-rx - (double)x, -ry - (double)y, -rz - (double)z), (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    if ((pathingTargets = climber.getTrackedPathingTargets()) != null) {
                        int i = 0;
                        for (PathingTarget pathingTarget : pathingTargets) {
                            BlockPos pos = pathingTarget.pos;
                            LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)bufferIn.getBuffer((RenderType)RenderType.LINES), (AABB)new AABB(pos).move(-rx - (double)x, -ry - (double)y, -rz - (double)z), (float)1.0f, (float)((float)i / (float)(pathingTargets.size() - 1)), (float)0.0f, (float)0.15f);
                            matrixStack.pushPose();
                            matrixStack.translate((double)pos.getX() + 0.5 - rx - (double)x, (double)pos.getY() + 0.5 - ry - (double)y, (double)pos.getZ() + 0.5 - rz - (double)z);
                            matrixStack.mulPose(pathingTarget.side.getOpposite().getRotation());
                            LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)bufferIn.getBuffer((RenderType)RenderType.LINES), (AABB)new AABB(-0.501, -0.501, -0.501, 0.501, -0.45, 0.501), (float)1.0f, (float)((float)i / (float)(pathingTargets.size() - 1)), (float)0.0f, (float)1.0f);
                            Matrix4f matrix4f = matrixStack.last().pose();
                            VertexConsumer builder = bufferIn.getBuffer((RenderType)RenderType.LINES);
                            builder.vertex(matrix4f, -0.501f, -0.45f, -0.501f).color(1.0f, (float)i / (float)(pathingTargets.size() - 1), 0.0f, 1.0f).endVertex();
                            builder.vertex(matrix4f, 0.501f, -0.45f, 0.501f).color(1.0f, (float)i / (float)(pathingTargets.size() - 1), 0.0f, 1.0f).endVertex();
                            builder.vertex(matrix4f, -0.501f, -0.45f, 0.501f).color(1.0f, (float)i / (float)(pathingTargets.size() - 1), 0.0f, 1.0f).endVertex();
                            builder.vertex(matrix4f, 0.501f, -0.45f, -0.501f).color(1.0f, (float)i / (float)(pathingTargets.size() - 1), 0.0f, 1.0f).endVertex();
                            matrixStack.popPose();
                            ++i;
                        }
                    }
                    Matrix4f matrix4f = matrixStack.last().pose();
                    VertexConsumer builder = bufferIn.getBuffer((RenderType)RenderType.LINES);
                    builder.vertex(matrix4f, 0.0f, 0.0f, 0.0f).color(0, 1, 1, 1).normal(0.0f, 0.0f, 0.0f).endVertex();
                    builder.vertex(matrix4f, (float)orientation.normal.x * 2.0f, (float)orientation.normal.y * 2.0f, (float)orientation.normal.z * 2.0f).color(1.0f, 0.0f, 1.0f, 1.0f).normal(0.0f, 0.0f, 0.0f).endVertex();
                    LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)bufferIn.getBuffer((RenderType)RenderType.LINES), (AABB)new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).move((double)((float)orientation.normal.x * 2.0f), (double)((float)orientation.normal.y * 2.0f), (double)((float)orientation.normal.z * 2.0f)).inflate((double)0.025f), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                    matrixStack.pushPose();
                    matrixStack.translate(-x, -y, -z);
                    matrix4f = matrixStack.last().pose();
                    builder.vertex(matrix4f, 0.0f, entity.getBbHeight() * 0.5f, 0.0f).color(0, 1, 1, 1).normal(0.0f, 0.0f, 0.0f).endVertex();
                    builder.vertex(matrix4f, (float)orientation.localX.x, entity.getBbHeight() * 0.5f + (float)orientation.localX.y, (float)orientation.localX.z).color(1.0f, 0.0f, 0.0f, 1.0f).normal(0.0f, 0.0f, 0.0f).endVertex();
                    LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)bufferIn.getBuffer((RenderType)RenderType.LINES), (AABB)new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).move((double)((float)orientation.localX.x), (double)(entity.getBbHeight() * 0.5f + (float)orientation.localX.y), (double)((float)orientation.localX.z)).inflate((double)0.025f), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    builder.vertex(matrix4f, 0.0f, entity.getBbHeight() * 0.5f, 0.0f).color(0, 1, 1, 1).normal(0.0f, 0.0f, 0.0f).endVertex();
                    builder.vertex(matrix4f, (float)orientation.localY.x, entity.getBbHeight() * 0.5f + (float)orientation.localY.y, (float)orientation.localY.z).color(0.0f, 1.0f, 0.0f, 1.0f).normal(0.0f, 0.0f, 0.0f).endVertex();
                    LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)bufferIn.getBuffer((RenderType)RenderType.LINES), (AABB)new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).move((double)((float)orientation.localY.x), (double)(entity.getBbHeight() * 0.5f + (float)orientation.localY.y), (double)((float)orientation.localY.z)).inflate((double)0.025f), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    builder.vertex(matrix4f, 0.0f, entity.getBbHeight() * 0.5f, 0.0f).color(0, 1, 1, 1).normal(0.0f, 0.0f, 0.0f).endVertex();
                    builder.vertex(matrix4f, (float)orientation.localZ.x, entity.getBbHeight() * 0.5f + (float)orientation.localZ.y, (float)orientation.localZ.z).color(0.0f, 0.0f, 1.0f, 1.0f).normal(0.0f, 0.0f, 0.0f).endVertex();
                    LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)bufferIn.getBuffer((RenderType)RenderType.LINES), (AABB)new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).move((double)((float)orientation.localZ.x), (double)(entity.getBbHeight() * 0.5f + (float)orientation.localZ.y), (double)((float)orientation.localZ.z)).inflate((double)0.025f), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                    matrixStack.popPose();
                }
                matrixStack.translate(-x, -y, -z);
            }
        }
    }
}

