/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsspiders.common.entity.movement;

import com.google.common.collect.ImmutableSet;
import com.nyfaria.nyfsspiders.common.entity.mob.IClimberEntity;
import com.nyfaria.nyfsspiders.common.entity.mob.Orientation;
import com.nyfaria.nyfsspiders.common.entity.movement.AdvancedGroundPathNavigator;
import com.nyfaria.nyfsspiders.common.entity.movement.AdvancedWalkNodeProcessor;
import com.nyfaria.nyfsspiders.common.entity.movement.ClimberMoveController;
import com.nyfaria.nyfsspiders.common.entity.movement.DirectionalPathPoint;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AdvancedClimberPathNavigator<T extends Mob>
extends AdvancedGroundPathNavigator<T> {
    protected final IClimberEntity climber;
    protected Direction verticalFacing = Direction.DOWN;
    protected boolean findDirectPathPoints = false;

    public AdvancedClimberPathNavigator(T entity, Level worldIn, boolean checkObstructions, boolean canPathWalls, boolean canPathCeiling) {
        super(entity, worldIn, checkObstructions);
        this.climber = (IClimberEntity)entity;
        if (this.nodeEvaluator instanceof AdvancedWalkNodeProcessor) {
            AdvancedWalkNodeProcessor processor = (AdvancedWalkNodeProcessor)this.nodeEvaluator;
            processor.setStartPathOnGround(false);
            processor.setCanPathWalls(canPathWalls);
            processor.setCanPathCeiling(canPathCeiling);
        }
    }

    protected Vec3 getTempMobPos() {
        return this.mob.position().add(0.0, (double)(this.mob.getBbHeight() / 2.0f), 0.0);
    }

    @Nullable
    public Path createPath(BlockPos pos, int checkpointRange) {
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)pos), 8, false, checkpointRange);
    }

    @Nullable
    public Path createPath(Entity entityIn, int checkpointRange) {
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)entityIn.blockPosition()), 16, true, checkpointRange);
    }

    public void tick() {
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (!this.isDone()) {
            if (this.canUpdatePath()) {
                this.followThePath();
            } else if (this.path != null && !this.path.isDone()) {
                Vec3 pos = this.getTempMobPos();
                Vec3 targetPos = this.path.getNextEntityPos((Entity)this.mob);
                if (pos.y > targetPos.y && !this.mob.onGround() && Mth.floor((double)pos.x) == Mth.floor((double)targetPos.x) && Mth.floor((double)pos.z) == Mth.floor((double)targetPos.z)) {
                    this.path.advance();
                }
            }
            DebugPackets.sendPathFindingPacket((Level)this.level, (Mob)this.mob, (Path)this.path, (float)this.maxDistanceToWaypoint);
            if (!this.isDone()) {
                Node targetPoint = this.path.getNode(this.path.getNextNodeIndex());
                Direction dir = null;
                if (targetPoint instanceof DirectionalPathPoint) {
                    dir = ((DirectionalPathPoint)targetPoint).getPathSide();
                }
                if (dir == null) {
                    dir = Direction.DOWN;
                }
                Vec3 targetPos = this.getExactPathingTarget((BlockGetter)this.level, targetPoint.asBlockPos(), dir);
                MoveControl moveController = this.mob.getMoveControl();
                if (moveController instanceof ClimberMoveController && targetPoint instanceof DirectionalPathPoint && ((DirectionalPathPoint)targetPoint).getPathSide() != null) {
                    ((ClimberMoveController)moveController).setMoveTo(targetPos.x, targetPos.y, targetPos.z, targetPoint.asBlockPos().relative(dir), ((DirectionalPathPoint)targetPoint).getPathSide(), this.speedModifier);
                } else {
                    moveController.setWantedPosition(targetPos.x, targetPos.y, targetPos.z, this.speedModifier);
                }
            }
        }
    }

    public Vec3 getExactPathingTarget(BlockGetter blockaccess, BlockPos pos, Direction dir) {
        BlockPos offsetPos = pos.relative(dir);
        VoxelShape shape = blockaccess.getBlockState(offsetPos).getCollisionShape(blockaccess, offsetPos);
        Direction.Axis axis = dir.getAxis();
        int sign = dir.getStepX() + dir.getStepY() + dir.getStepZ();
        double offset = shape.isEmpty() ? (double)sign : (sign > 0 ? shape.min(axis) - 1.0 : shape.max(axis));
        double marginXZ = 1.0f - this.mob.getBbWidth() % 1.0f;
        double marginY = 1.0f - this.mob.getBbHeight() % 1.0f;
        double pathingOffsetXZ = (double)((int)(this.mob.getBbWidth() + 1.0f)) * 0.5;
        double pathingOffsetY = (double)((int)(this.mob.getBbHeight() + 1.0f)) * 0.5 - (double)(this.mob.getBbHeight() * 0.5f);
        double x = (double)offsetPos.getX() + pathingOffsetXZ + (double)dir.getStepX() * marginXZ;
        double y = (double)offsetPos.getY() + pathingOffsetY + (dir == Direction.DOWN ? -pathingOffsetY : 0.0) + (dir == Direction.UP ? -pathingOffsetY + marginY : 0.0);
        double z = (double)offsetPos.getZ() + pathingOffsetXZ + (double)dir.getStepZ() * marginXZ;
        switch (axis) {
            default: {
                return new Vec3(x + offset, y, z);
            }
            case Y: {
                return new Vec3(x, y + offset, z);
            }
            case Z: 
        }
        return new Vec3(x, y, z + offset);
    }

    protected void followThePath() {
        Vec3 pos = this.getTempMobPos();
        this.maxDistanceToWaypoint = this.mob.getBbWidth() > 0.75f ? this.mob.getBbWidth() / 2.0f : 0.75f - this.mob.getBbWidth() / 2.0f;
        float maxDistanceToWaypointY = Math.max(1.0f, this.mob.getBbHeight() > 0.75f ? this.mob.getBbHeight() / 2.0f : 0.75f - this.mob.getBbHeight() / 2.0f);
        int sizeX = Mth.ceil((float)this.mob.getBbWidth());
        int sizeY = Mth.ceil((float)this.mob.getBbHeight());
        int sizeZ = sizeX;
        Orientation orientation = this.climber.getOrientation();
        Vec3 upVector = orientation.getGlobal(this.mob.yRot, -90.0f);
        this.verticalFacing = Direction.getNearest((float)((float)upVector.x), (float)((float)upVector.y), (float)((float)upVector.z));
        for (int i = 4; i >= 0; --i) {
            Direction targetSide;
            if (this.path.getNextNodeIndex() + i >= this.path.getNodeCount()) continue;
            Node currentTarget = this.path.getNode(this.path.getNextNodeIndex() + i);
            double dx = Math.abs((double)((float)currentTarget.x + (float)((int)(this.mob.getBbWidth() + 1.0f)) * 0.5f) - this.mob.getX());
            double dy = Math.abs((double)currentTarget.y - this.mob.getY());
            double dz = Math.abs((double)((float)currentTarget.z + (float)((int)(this.mob.getBbWidth() + 1.0f)) * 0.5f) - this.mob.getZ());
            boolean isWaypointInReach = dx < (double)this.maxDistanceToWaypoint && dy < (double)maxDistanceToWaypointY && dz < (double)this.maxDistanceToWaypoint;
            boolean isOnSameSideAsTarget = false;
            isOnSameSideAsTarget = this.canFloat() && (currentTarget.type == BlockPathTypes.WATER || currentTarget.type == BlockPathTypes.WATER_BORDER || currentTarget.type == BlockPathTypes.LAVA) ? true : (currentTarget instanceof DirectionalPathPoint ? (targetSide = ((DirectionalPathPoint)currentTarget).getPathSide()) == null || this.climber.getGroundDirection().getLeft() == targetSide : true);
            if (!isOnSameSideAsTarget || !isWaypointInReach && (i != 0 || !this.mob.getNavigation().canCutCorner(this.path.getNextNode().type) || !this.isNextTargetInLine(pos, sizeX, sizeY, sizeZ, 1 + i))) continue;
            this.path.setNextNodeIndex(this.path.getNextNodeIndex() + 1 + i);
            break;
        }
        if (this.findDirectPathPoints) {
            Direction.Axis verticalAxis = this.verticalFacing.getAxis();
            int firstDifferentHeightPoint = this.path.getNodeCount();
            block0 : switch (verticalAxis) {
                case X: {
                    for (int i = this.path.getNextNodeIndex(); i < this.path.getNodeCount(); ++i) {
                        if ((double)this.path.getNode((int)i).x == Math.floor(pos.x)) continue;
                        firstDifferentHeightPoint = i;
                        break block0;
                    }
                    break;
                }
                case Y: {
                    for (int i = this.path.getNextNodeIndex(); i < this.path.getNodeCount(); ++i) {
                        if ((double)this.path.getNode((int)i).y == Math.floor(pos.y)) continue;
                        firstDifferentHeightPoint = i;
                        break block0;
                    }
                    break;
                }
                case Z: {
                    for (int i = this.path.getNextNodeIndex(); i < this.path.getNodeCount(); ++i) {
                        if ((double)this.path.getNode((int)i).z == Math.floor(pos.z)) continue;
                        firstDifferentHeightPoint = i;
                        break block0;
                    }
                    break;
                }
            }
            for (int i = firstDifferentHeightPoint - 1; i >= this.path.getNextNodeIndex(); --i) {
                if (!this.canMoveDirectly(pos, this.path.getEntityPosAtNode((Entity)this.mob, i))) continue;
                this.path.setNextNodeIndex(i);
                break;
            }
        }
        this.doStuckDetection(pos);
    }

    private boolean isNextTargetInLine(Vec3 pos, int sizeX, int sizeY, int sizeZ, int offset) {
        Vec3 currentDir;
        if (this.path.getNextNodeIndex() + offset >= this.path.getNodeCount()) {
            return false;
        }
        Vec3 currentTarget = Vec3.atBottomCenterOf((Vec3i)this.path.getNextNodePos());
        if (!pos.closerThan((Position)currentTarget, 2.0)) {
            return false;
        }
        Vec3 nextTarget = Vec3.atBottomCenterOf((Vec3i)this.path.getNodePos(this.path.getNextNodeIndex() + offset));
        Vec3 targetDir = nextTarget.subtract(currentTarget);
        if (targetDir.dot(currentDir = pos.subtract(currentTarget)) > 0.0) {
            Direction.Axis az;
            Direction.Axis ay;
            Direction.Axis ax;
            return this.isSafeToStandAt(Mth.floor((double)nextTarget.x), Mth.floor((double)nextTarget.y), Mth.floor((double)nextTarget.z), sizeX, sizeY, sizeZ, currentTarget, 0.0, 0.0, -1.0, ax, ay, az, switch (this.verticalFacing.getAxis()) {
                case Direction.Axis.X -> {
                    ax = Direction.Axis.Z;
                    ay = Direction.Axis.X;
                    az = Direction.Axis.Y;
                    yield this.verticalFacing.getStepX() < 0;
                }
                default -> {
                    ax = Direction.Axis.X;
                    ay = Direction.Axis.Y;
                    az = Direction.Axis.Z;
                    yield this.verticalFacing.getStepY() < 0;
                }
                case Direction.Axis.Z -> {
                    ax = Direction.Axis.Y;
                    ay = Direction.Axis.Z;
                    az = Direction.Axis.X;
                    yield this.verticalFacing.getStepZ() < 0;
                }
            });
        }
        return false;
    }

    protected boolean canMoveDirectly(Vec3 start, Vec3 end) {
        int sizeX = 0;
        int sizeY = 0;
        int sizeZ = 0;
        switch (this.verticalFacing.getAxis()) {
            case X: {
                return this.isDirectPathBetweenPoints(start, end, sizeX, sizeY, sizeZ, Direction.Axis.Z, Direction.Axis.X, Direction.Axis.Y, 0.0, this.verticalFacing.getStepX() < 0);
            }
            case Y: {
                return this.isDirectPathBetweenPoints(start, end, sizeX, sizeY, sizeZ, Direction.Axis.X, Direction.Axis.Y, Direction.Axis.Z, 0.0, this.verticalFacing.getStepY() < 0);
            }
            case Z: {
                return this.isDirectPathBetweenPoints(start, end, sizeX, sizeY, sizeZ, Direction.Axis.Y, Direction.Axis.Z, Direction.Axis.X, 0.0, this.verticalFacing.getStepZ() < 0);
            }
        }
        return false;
    }

    protected static double swizzle(Vec3 vec, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return vec.x;
            }
            case Y: {
                return vec.y;
            }
            case Z: {
                return vec.z;
            }
        }
        return 0.0;
    }

    protected static int swizzle(int x, int y, int z, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return x;
            }
            case Y: {
                return y;
            }
            case Z: {
                return z;
            }
        }
        return 0;
    }

    protected static int unswizzle(int x, int y, int z, Direction.Axis ax, Direction.Axis ay, Direction.Axis az, Direction.Axis axis) {
        Direction.Axis unswizzle = axis == ax ? Direction.Axis.X : (axis == ay ? Direction.Axis.Y : Direction.Axis.Z);
        return AdvancedClimberPathNavigator.swizzle(x, y, z, unswizzle);
    }

    protected boolean isDirectPathBetweenPoints(Vec3 start, Vec3 end, int sizeX, int sizeY, int sizeZ, Direction.Axis ax, Direction.Axis ay, Direction.Axis az, double minDotProduct, boolean invertY) {
        int bx = Mth.floor((double)AdvancedClimberPathNavigator.swizzle(start, ax));
        int bz = Mth.floor((double)AdvancedClimberPathNavigator.swizzle(start, az));
        double dx = AdvancedClimberPathNavigator.swizzle(end, ax) - AdvancedClimberPathNavigator.swizzle(start, ax);
        double dz = AdvancedClimberPathNavigator.swizzle(end, az) - AdvancedClimberPathNavigator.swizzle(start, az);
        double dSq = dx * dx + dz * dz;
        int by = (int)AdvancedClimberPathNavigator.swizzle(start, ay);
        int sizeX2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, ax);
        int sizeY2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, ay);
        int sizeZ2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, az);
        if (dSq < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(dSq);
        if (!this.isSafeToStandAt(AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.Z), AdvancedClimberPathNavigator.unswizzle(sizeX2 += 2, sizeY2, sizeZ2 += 2, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, Direction.Axis.Z), start, dx *= d3, dz *= d3, minDotProduct, ax, ay, az, invertY)) {
            return false;
        }
        sizeX2 -= 2;
        sizeZ2 -= 2;
        double stepX = 1.0 / Math.abs(dx);
        double stepZ = 1.0 / Math.abs(dz);
        double relX = (double)bx - AdvancedClimberPathNavigator.swizzle(start, ax);
        double relZ = (double)bz - AdvancedClimberPathNavigator.swizzle(start, az);
        if (dx >= 0.0) {
            relX += 1.0;
        }
        if (dz >= 0.0) {
            relZ += 1.0;
        }
        relX /= dx;
        relZ /= dz;
        int dirX = dx < 0.0 ? -1 : 1;
        int dirZ = dz < 0.0 ? -1 : 1;
        int ex = Mth.floor((double)AdvancedClimberPathNavigator.swizzle(end, ax));
        int ez = Mth.floor((double)AdvancedClimberPathNavigator.swizzle(end, az));
        int offsetX = ex - bx;
        int offsetZ = ez - bz;
        while (offsetX * dirX > 0 || offsetZ * dirZ > 0) {
            if (relX < relZ) {
                relX += stepX;
                offsetX = ex - (bx += dirX);
            } else {
                relZ += stepZ;
                offsetZ = ez - (bz += dirZ);
            }
            if (this.isSafeToStandAt(AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.Z), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, Direction.Axis.Z), start, dx, dz, minDotProduct, ax, ay, az, invertY)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSafeToStandAt(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3 start, double dx, double dz, double minDotProduct, Direction.Axis ax, Direction.Axis ay, Direction.Axis az, boolean invertY) {
        int sizeX2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, ax);
        int sizeZ2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, az);
        int bx = AdvancedClimberPathNavigator.swizzle(x, y, z, ax) - sizeX2 / 2;
        int bz = AdvancedClimberPathNavigator.swizzle(x, y, z, az) - sizeZ2 / 2;
        int by = AdvancedClimberPathNavigator.swizzle(x, y, z, ay);
        if (!this.isPositionClear(AdvancedClimberPathNavigator.unswizzle(bx, y, bz, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(bx, y, bz, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(bx, y, bz, ax, ay, az, Direction.Axis.Z), sizeX, sizeY, sizeZ, start, dx, dz, minDotProduct, ax, ay, az)) {
            return false;
        }
        for (int obx = bx; obx < bx + sizeX2; ++obx) {
            for (int obz = bz; obz < bz + sizeZ2; ++obz) {
                double offsetZ;
                double offsetX = (double)obx + 0.5 - AdvancedClimberPathNavigator.swizzle(start, ax);
                if (!(offsetX * dx + (offsetZ = (double)obz + 0.5 - AdvancedClimberPathNavigator.swizzle(start, az)) * dz >= minDotProduct)) continue;
                BlockPathTypes nodeTypeBelow = this.nodeEvaluator.getBlockPathType((BlockGetter)this.level, AdvancedClimberPathNavigator.unswizzle(obx, by + (invertY ? 1 : -1), obz, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(obx, by + (invertY ? 1 : -1), obz, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(obx, by + (invertY ? 1 : -1), obz, ax, ay, az, Direction.Axis.Z), this.mob);
                if (nodeTypeBelow == BlockPathTypes.WATER) {
                    return false;
                }
                if (nodeTypeBelow == BlockPathTypes.LAVA) {
                    return false;
                }
                if (nodeTypeBelow == BlockPathTypes.OPEN) {
                    return false;
                }
                BlockPathTypes nodeType = this.nodeEvaluator.getBlockPathType((BlockGetter)this.level, AdvancedClimberPathNavigator.unswizzle(obx, by, obz, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(obx, by, obz, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(obx, by, obz, ax, ay, az, Direction.Axis.Z), this.mob);
                float f = this.mob.getPathfindingMalus(nodeType);
                if (f < 0.0f || f >= 8.0f) {
                    return false;
                }
                if (nodeType != BlockPathTypes.DAMAGE_FIRE && nodeType != BlockPathTypes.DANGER_FIRE && nodeType != BlockPathTypes.DAMAGE_OTHER) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isPositionClear(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3 start, double dx, double dz, double minDotProduct, Direction.Axis ax, Direction.Axis ay, Direction.Axis az) {
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)new BlockPos(x, y, z), (BlockPos)new BlockPos(x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1))) {
            BlockState state;
            double pffsetZ;
            double offsetX;
            if (this.level.isLoaded(pos) || !((offsetX = (double)AdvancedClimberPathNavigator.swizzle(pos.getX(), pos.getY(), pos.getZ(), ax) + 0.5 - AdvancedClimberPathNavigator.swizzle(start, ax)) * dx + (pffsetZ = (double)AdvancedClimberPathNavigator.swizzle(pos.getX(), pos.getY(), pos.getZ(), az) + 0.5 - AdvancedClimberPathNavigator.swizzle(start, az)) * dz >= minDotProduct) || (state = this.level.getBlockState(pos)).isPathfindable((BlockGetter)this.level, pos, PathComputationType.LAND)) continue;
            return false;
        }
        return true;
    }
}

