/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsspiders.common.entity.movement;

import com.nyfaria.nyfsspiders.CommonClass;
import com.nyfaria.nyfsspiders.common.entity.movement.AdvancedPathFinder;
import com.nyfaria.nyfsspiders.common.entity.movement.AdvancedWalkNodeProcessor;
import com.nyfaria.nyfsspiders.common.entity.movement.IAdvancedPathFindingEntity;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AdvancedGroundPathNavigator<T extends Mob>
extends GroundPathNavigation {
    protected AdvancedPathFinder pathFinder;
    protected long lastTimeUpdated;
    protected BlockPos targetPos;
    protected final T advancedPathFindingEntity;
    protected final boolean checkObstructions;
    protected int stuckCheckTicks = 0;
    protected int checkpointRange;

    public AdvancedGroundPathNavigator(T entity, Level worldIn) {
        this(entity, worldIn, true);
    }

    public AdvancedGroundPathNavigator(T entity, Level worldIn, boolean checkObstructions) {
        super(entity, worldIn);
        this.advancedPathFindingEntity = entity;
        this.checkObstructions = checkObstructions;
        if (this.nodeEvaluator instanceof AdvancedWalkNodeProcessor) {
            AdvancedWalkNodeProcessor processor = (AdvancedWalkNodeProcessor)this.nodeEvaluator;
            processor.setCheckObstructions(checkObstructions);
        }
    }

    public AdvancedPathFinder getAssignedPathFinder() {
        return this.pathFinder;
    }

    protected final PathFinder createPathFinder(int maxExpansions) {
        this.pathFinder = this.createAdvancedPathFinder(maxExpansions);
        this.nodeEvaluator = this.pathFinder.getNodeProcessor();
        return this.pathFinder;
    }

    protected AdvancedPathFinder createAdvancedPathFinder(int maxExpansions) {
        AdvancedWalkNodeProcessor nodeProcessor = new AdvancedWalkNodeProcessor();
        nodeProcessor.setCanPassDoors(true);
        return new AdvancedPathFinder((NodeEvaluator)nodeProcessor, maxExpansions);
    }

    @Nullable
    protected Path createPath(Set<BlockPos> waypoints, int padding, boolean startAbove, int checkpointRange) {
        HashSet<BlockPos> adjustedWaypoints = new HashSet<BlockPos>();
        for (BlockPos pos : waypoints) {
            adjustedWaypoints.add(pos.offset(-Mth.ceil((float)this.mob.getBbWidth()) + 1, -Mth.ceil((float)this.mob.getBbHeight()) + 1, -Mth.ceil((float)this.mob.getBbWidth()) + 1));
        }
        Path path = super.createPath(adjustedWaypoints, padding, startAbove, checkpointRange);
        if (path != null && path.getTarget() != null) {
            this.checkpointRange = checkpointRange;
        }
        return path;
    }

    public void recomputePath() {
        if (this.level.getGameTime() - this.lastTimeUpdated > 20L) {
            if (this.targetPos != null) {
                this.path = null;
                this.path = this.createPath(this.targetPos, this.checkpointRange);
                this.lastTimeUpdated = this.level.getGameTime();
                this.hasDelayedRecomputation = false;
            }
        } else {
            this.hasDelayedRecomputation = true;
        }
    }

    protected void doStuckDetection(Vec3 entityPos) {
        super.doStuckDetection(entityPos);
        if (this.checkObstructions && this.path != null && !this.path.isDone()) {
            Vec3 target = this.path.getEntityPosAtNode(this.advancedPathFindingEntity, Math.min(this.path.getNodeCount() - 1, this.path.getNextNodeIndex() + 0));
            Vec3 diff = target.subtract(entityPos);
            int axis = 0;
            double maxDiff = 0.0;
            for (int i = 0; i < 3; ++i) {
                double d = switch (i) {
                    default -> Math.abs(diff.x);
                    case 1 -> Math.abs(diff.y);
                    case 2 -> Math.abs(diff.z);
                };
                if (!(d > maxDiff)) continue;
                axis = i;
                maxDiff = d;
            }
            int height = Mth.floor((float)(this.advancedPathFindingEntity.getBbHeight() + 1.0f));
            int ceilHalfWidth = Mth.ceil((float)(this.advancedPathFindingEntity.getBbWidth() / 2.0f + 0.05f));
            Vec3 facingDiff = (switch (axis) {
                default -> new Vec3(entityPos.x + Math.signum(diff.x) * (double)ceilHalfWidth, entityPos.y, target.z);
                case 1 -> new Vec3(entityPos.x, entityPos.y + (double)(diff.y > 0.0 ? height + 1 : -1), target.z);
                case 2 -> new Vec3(target.x, entityPos.y, entityPos.z + Math.signum(diff.z) * (double)ceilHalfWidth);
            }).subtract(entityPos.add(0.0, axis == 1 ? (double)(this.mob.getBbHeight() / 2.0f) : 0.0, 0.0));
            Direction facing = Direction.getNearest((float)((float)facingDiff.x), (float)((float)facingDiff.y), (float)((float)facingDiff.z));
            boolean blocked = false;
            AABB checkBox = this.advancedPathFindingEntity.getBoundingBox().expandTowards(Math.signum(diff.x) * 0.2, Math.signum(diff.y) * 0.2, Math.signum(diff.z) * 0.2);
            block9: for (int yo = 0; yo < height; ++yo) {
                for (int xzo = -ceilHalfWidth; xzo <= ceilHalfWidth; ++xzo) {
                    VoxelShape collisionShape;
                    BlockPathTypes nodeType;
                    BlockPos pos = CommonClass.blockPos(checkPos.x + (double)(axis != 0 ? xzo : 0), checkPos.y + (double)(axis != 1 ? yo : 0), checkPos.z + (double)(axis != 2 ? xzo : 0));
                    BlockState state = this.advancedPathFindingEntity.level().getBlockState(pos);
                    BlockPathTypes blockPathTypes = nodeType = state.isPathfindable((BlockGetter)this.advancedPathFindingEntity.level(), pos, PathComputationType.LAND) ? BlockPathTypes.OPEN : BlockPathTypes.BLOCKED;
                    if (nodeType != BlockPathTypes.BLOCKED || (collisionShape = state.getShape((BlockGetter)this.advancedPathFindingEntity.level(), pos, CollisionContext.of(this.advancedPathFindingEntity)).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())) == null || !collisionShape.toAabbs().stream().anyMatch(aabb -> aabb.intersects(checkBox))) continue;
                    blocked = true;
                    break block9;
                }
            }
            if (blocked) {
                ++this.stuckCheckTicks;
                if (this.stuckCheckTicks > ((IAdvancedPathFindingEntity)this.advancedPathFindingEntity).getMaxStuckCheckTicks()) {
                    ((IAdvancedPathFindingEntity)this.advancedPathFindingEntity).onPathingObstructed(facing);
                    this.stuckCheckTicks = 0;
                }
            } else {
                this.stuckCheckTicks = Math.max(this.stuckCheckTicks - 2, 0);
            }
        } else {
            this.stuckCheckTicks = Math.max(this.stuckCheckTicks - 4, 0);
        }
    }
}

