/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsspiders.common.entity.movement;

import com.nyfaria.nyfsspiders.common.entity.movement.CustomPathFinder;
import com.nyfaria.nyfsspiders.common.entity.movement.DirectionalPathPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public class AdvancedPathFinder
extends CustomPathFinder {
    private static final Direction[] DOWN = new Direction[]{Direction.DOWN};

    public AdvancedPathFinder(NodeEvaluator processor, int maxExpansions) {
        super(processor, maxExpansions);
    }

    @Override
    protected Path createPath(Node _targetPoint, BlockPos target, boolean isTargetReached) {
        ArrayList<Node> points = new ArrayList<Node>();
        this.backtrackPath(points, _targetPoint);
        TPONode end = this.retraceSidedPath(points, true);
        if (end == null) {
            return new Path(Collections.emptyList(), target, isTargetReached);
        }
        points.clear();
        this.backtrackPath(points, end);
        return new Path(points, target, isTargetReached);
    }

    private void backtrackPath(List<Node> points, Node start) {
        Node currentPathPoint = start;
        points.add(start);
        while (currentPathPoint.cameFrom != null) {
            currentPathPoint = currentPathPoint.cameFrom;
            points.add(currentPathPoint);
        }
    }

    private void backtrackPath(List<Node> points, TPONode start) {
        TPONode currentTPONode = start;
        points.add(start.pathPoint);
        while (currentTPONode.previous != null) {
            currentTPONode = currentTPONode.previous;
            points.add(currentTPONode.pathPoint);
        }
    }

    private static Direction[] getPathableSidesWithFallback(DirectionalPathPoint point) {
        if (point.getPathableSides().length == 0) {
            return DOWN;
        }
        return point.getPathableSides();
    }

    private static boolean isOmnidirectionalPoint(DirectionalPathPoint point) {
        return point.type == BlockPathTypes.WATER || point.type == BlockPathTypes.LAVA;
    }

    private TPONode retraceSidedPath(List<Node> points, boolean isReversed) {
        if (points.isEmpty()) {
            return null;
        }
        LinkedList<TPONode> queue = new LinkedList<TPONode>();
        DirectionalPathPoint targetPoint = this.ensureDirectional(points.get(0));
        for (Direction direction : AdvancedPathFinder.getPathableSidesWithFallback(targetPoint)) {
            queue.add(new TPONode(null, targetPoint.assignPathSide(direction)));
        }
        TPONode end = null;
        int maxExpansions = 200;
        HashSet<TPONode> checkedSet = new HashSet<TPONode>();
        int expansions = 0;
        while (!queue.isEmpty() && expansions++ <= 200) {
            TPONode current = (TPONode)queue.removeFirst();
            if (current.depth == points.size() - 1) {
                end = current;
                break;
            }
            Direction currentSide = current.side;
            DirectionalPathPoint next = this.ensureDirectional(points.get(current.depth + 1));
            for (Direction nextSide : AdvancedPathFinder.getPathableSidesWithFallback(next)) {
                TPONode nextTPONode = null;
                if (isReversed && current.pathPoint.isDrop() || !isReversed && next.isDrop()) {
                    nextTPONode = new TPONode(current, next.assignPathSide(nextSide));
                } else {
                    int adz;
                    int ady;
                    int dx = (int)Math.signum(next.x - current.pathPoint.x);
                    int dy = (int)Math.signum(next.y - current.pathPoint.y);
                    int dz = (int)Math.signum(next.z - current.pathPoint.z);
                    int adx = Math.abs(dx);
                    int d = adx + (ady = Math.abs(dy)) + (adz = Math.abs(dz));
                    if (d == 1) {
                        if (nextSide == currentSide) {
                            nextTPONode = new TPONode(current, next.assignPathSide(nextSide));
                        } else if (nextSide.getAxis() != currentSide.getAxis()) {
                            TPONode intermediary = Math.abs(currentSide.getStepX()) == adx && Math.abs(currentSide.getStepY()) == ady && Math.abs(currentSide.getStepZ()) == adz ? new TPONode(current, current.pathPoint.assignPathSide(nextSide)) : new TPONode(current, next.assignPathSide(currentSide));
                            nextTPONode = new TPONode(intermediary, intermediary.depth, next.assignPathSide(nextSide));
                        }
                    } else if (d == 2) {
                        int currentSidePlaneMatch = (currentSide.getStepX() == -dx ? 1 : 0) + (currentSide.getStepY() == -dy ? 1 : 0) + (currentSide.getStepZ() == -dz ? 1 : 0);
                        if (currentSide == nextSide && currentSidePlaneMatch == 0) {
                            nextTPONode = new TPONode(current, next.assignPathSide(nextSide));
                        } else {
                            TPONode intermediary = null;
                            if (currentSidePlaneMatch == 2) {
                                for (Direction intermediarySide : AdvancedPathFinder.getPathableSidesWithFallback(current.pathPoint)) {
                                    if (intermediarySide == currentSide || (intermediarySide.getStepX() == dx ? 1 : 0) + (intermediarySide.getStepY() == dy ? 1 : 0) + (intermediarySide.getStepZ() == dz ? 1 : 0) != 2) continue;
                                    intermediary = new TPONode(current, current.pathPoint.assignPathSide(intermediarySide));
                                    break;
                                }
                            } else {
                                for (Direction intermediarySide : AdvancedPathFinder.getPathableSidesWithFallback(next)) {
                                    if (intermediarySide == nextSide || (intermediarySide.getStepX() == -dx ? 1 : 0) + (intermediarySide.getStepY() == -dy ? 1 : 0) + (intermediarySide.getStepZ() == -dz ? 1 : 0) != 2) continue;
                                    intermediary = new TPONode(current, next.assignPathSide(intermediarySide));
                                    break;
                                }
                            }
                            nextTPONode = intermediary != null ? new TPONode(intermediary, intermediary.depth, next.assignPathSide(nextSide)) : new TPONode(current, next.assignPathSide(nextSide));
                        }
                    }
                }
                if (nextTPONode == null || !checkedSet.add(nextTPONode)) continue;
                queue.addLast(nextTPONode);
            }
        }
        return end;
    }

    private DirectionalPathPoint ensureDirectional(Node point) {
        if (point instanceof DirectionalPathPoint) {
            return (DirectionalPathPoint)point;
        }
        return new DirectionalPathPoint(point);
    }

    private static class TPONode {
        private final TPONode previous;
        private final DirectionalPathPoint pathPoint;
        private final Direction side;
        private final int depth;

        private TPONode(@Nullable TPONode previous, DirectionalPathPoint pathPoint) {
            this.previous = previous;
            this.depth = previous != null ? previous.depth + 1 : 0;
            this.pathPoint = pathPoint;
            this.side = pathPoint.getPathSide();
        }

        private TPONode(TPONode previous, int depth, DirectionalPathPoint pathPoint) {
            this.previous = previous;
            this.depth = depth;
            this.pathPoint = pathPoint;
            this.side = pathPoint.getPathSide();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pathPoint == null ? 0 : this.pathPoint.hashCode());
            result = 31 * result + (this.side == null ? 0 : this.side.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TPONode other = (TPONode)obj;
            if (this.pathPoint == null ? other.pathPoint != null : !this.pathPoint.equals((Object)other.pathPoint)) {
                return false;
            }
            return this.side == other.side;
        }
    }
}

